/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.emu.EmuUtilities;
import org.jlab.coda.jevio.EventParser;

public class ReceiverCmsg {
    private String subject = "BitBucket";
    private String type = "data";
    private String name = "BitBucket";
    private String channelName = "BitBucket_SOCKET";
    private String description = "place to dump EMU data";
    private String UDL;
    private int delay;
    private int count = 5000;
    private int timeout = 3000;
    private boolean debug;
    private cMsg coda;
    private cMsgSubscriptionHandle sub;
    EventParser parser;

    ReceiverCmsg(String[] args) {
        this.decodeCommandLine(args);
        this.parser = new EventParser();
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                ReceiverCmsg.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(args[i + 1]);
                if (this.count < 1) {
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-to")) {
                this.timeout = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            ReceiverCmsg.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java ReceiverCmsg\n        [-n <name>]          set client name\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <sender>]        set sender of EMU data\n        [-t <type>]          set type of subscription/sent messages\n        [-c <count>]         set # of messages to get before printing output\n        [-to <time>]         set timeout\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            ReceiverCmsg receiver = new ReceiverCmsg(args);
            receiver.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running ReceiverCmsg as EMU's bitbucket\n");
        }
        if (this.UDL == null) {
            this.UDL = System.getProperty("cmsgUDL");
        }
        if (this.UDL == null) {
            this.UDL = "cMsg://localhost/cMsg/test";
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        myCallback cb = new myCallback();
        this.sub = this.coda.subscribe(this.subject, this.type, (cMsgCallbackInterface)cb, null);
        this.coda.start();
        long totalT = 0L;
        long totalC = 0L;
        long period = 2000L;
        while (true) {
            this.count = 0;
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            double freq = (double)this.count / (double)period * 1000.0;
            double freqAvg = (double)(totalC += (long)this.count) / (double)(totalT += period) * 1000.0;
            if (this.debug) {
                System.out.println("count = " + this.count + ", total = " + totalC);
                System.out.println("freq  = " + EmuUtilities.doubleToString(freq, 1) + " Hz, Avg = " + EmuUtilities.doubleToString(freqAvg, 1) + " Hz");
            }
            if (this.coda.isConnected()) continue;
            System.out.println("No longer connected to domain server, quitting");
            System.exit(-1);
        }
    }

    class myCallback
    extends cMsgCallbackAdapter {
        myCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            byte[] data = msg.getByteArray();
            if (data == null) {
                System.out.println("ReceiverCmsg: got bogus message");
                return;
            }
            ReceiverCmsg.this.count++;
        }
    }
}

