/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.util.concurrent.CountDownLatch;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;

public class ByteBufferSupplyTest {
    private int size = 32;
    private int count = 4096;
    private int getChunk = 1;
    CountDownLatch startLatch;
    ByteBufferSupply bbSupply;
    boolean simpleTest = true;

    ByteBufferSupplyTest(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                ByteBufferSupplyTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.size = Integer.parseInt(args[i + 1]);
                if (this.size < 1) {
                    System.out.println("Buffer size must be > 0");
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(args[i + 1]);
                if (this.count < 1) {
                    System.out.println("Buffer count must be > 0");
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-g")) {
                this.getChunk = Integer.parseInt(args[i + 1]);
                if (this.getChunk < 1) {
                    System.out.println("Get chunk must be > 0");
                    System.exit(-1);
                }
                System.out.println("Get chunk = " + this.getChunk);
                ++i;
                continue;
            }
            ByteBufferSupplyTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java ByteBufferSupplyTest\n        [-s <size>]    size in bytes of buffers\n        [-c <count>]   number of buffer in ring (must be power of 2)\n        [-g <chunk>]   number of buffers to get from ring at once (> 0)\n        [-h]           print this help\n");
    }

    public static void main(String[] args) {
        ByteBufferSupplyTest receiver = new ByteBufferSupplyTest(args);
        receiver.run();
    }

    public void run() {
        this.bbSupply = new ByteBufferSupply(this.count, this.size);
        boolean index = false;
        boolean releaseBuf = true;
        boolean publishBuf = false;
        if (!this.simpleTest) {
            try {
                this.startLatch = new CountDownLatch(1);
                RingConsumerThread rcThread = new RingConsumerThread();
                rcThread.start();
                this.startLatch.await();
            }
            catch (InterruptedException rcThread) {}
        } else {
            publishBuf = false;
        }
        while (true) {
            ByteBufferItem bufItem;
            try {
                bufItem = this.bbSupply.get();
            }
            catch (InterruptedException e) {
                return;
            }
            System.out.println(", got producer buf with id = " + bufItem.getMyId());
            if (!releaseBuf) {
                System.out.println("do NOT release producer buf");
            } else {
                this.bbSupply.release(bufItem);
            }
            if (!publishBuf) continue;
            System.out.println("publish producer buf");
            this.bbSupply.publish(bufItem);
        }
    }

    static /* synthetic */ int access$000(ByteBufferSupplyTest x0) {
        return x0.getChunk;
    }

    class RingConsumerThread
    extends Thread {
        RingConsumerThread() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            releaseBuf = true;
            ByteBufferSupplyTest.this.startLatch.countDown();
            try {
                bufItems = new ByteBufferItem[ByteBufferSupplyTest.access$000(ByteBufferSupplyTest.this)];
                while (true) lbl-1000:
                // 4 sources

                {
                    for (i = 0; i < ByteBufferSupplyTest.access$000(ByteBufferSupplyTest.this); ++i) {
                        System.out.println("     Try getting consumer buf ... ");
                        bufItems[i] = ByteBufferSupplyTest.this.bbSupply.consumerGet();
                        System.out.println("     Got consumer buf with id = " + bufItems[i].getMyId());
                    }
                    if (!releaseBuf) {
                        System.out.println("     do NOT release consumer bufs");
                        ** continue;
                    }
                    i = 0;
                    while (true) {
                        if (i < ByteBufferSupplyTest.access$000(ByteBufferSupplyTest.this)) ** break;
                        ** continue;
                        System.out.println("     Release consumer buf with id = " + bufItems[i].getMyId());
                        ByteBufferSupplyTest.this.bbSupply.release(bufItems[i]);
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

