/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannelAdapter;
import org.jlab.coda.emu.support.transport.DataTransportImplFifo;
import org.jlab.coda.emu.support.transport.TransportType;

public class DataChannelImplFifo
extends DataChannelAdapter {
    private final Thread movingThread;

    DataChannelImplFifo(String name, DataTransportImplFifo transport, Map<String, String> attributeMap, boolean input, Emu emu, EmuModule module) {
        super(name, transport, attributeMap, input, emu, module, 0);
        this.channelState = CODAState.PAUSED;
        DataMover mover = new DataMover();
        this.movingThread = new Thread(emu.getThreadGroup(), mover, this.name());
        this.movingThread.start();
        mover.waitUntilStarted();
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.FIFO;
    }

    @Override
    public void go() {
        this.pause = false;
        this.channelState = CODAState.ACTIVE;
    }

    @Override
    public void pause() {
        this.pause = true;
        this.channelState = CODAState.PAUSED;
    }

    @Override
    public void end() {
        this.gotEndCmd = true;
        this.gotResetCmd = false;
        if (this.movingThread != null) {
            this.movingThread.interrupt();
        }
        this.channelState = CODAState.DOWNLOADED;
    }

    @Override
    public void reset() {
        this.gotEndCmd = false;
        this.gotResetCmd = true;
        if (this.movingThread != null) {
            this.movingThread.interrupt();
        }
        this.channelState = CODAState.CONFIGURED;
    }

    private class DataMover
    implements Runnable {
        private CountDownLatch latch = new CountDownLatch(1);
        private int pauseCounter;

        private DataMover() {
        }

        private void waitUntilStarted() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private final void writeEvioData(RingItem ri) throws InterruptedException {
            long nextRingItem = DataChannelImplFifo.this.ringBufferIn.nextIntr(1);
            RingItem riOutput = (RingItem)DataChannelImplFifo.this.ringBufferIn.get(nextRingItem);
            riOutput.copy(ri);
            DataChannelImplFifo.this.ringBufferIn.publish(nextRingItem);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ControlType pBankControlType;
            EventType pBankType;
            RingItem ringItem;
            block12: {
                this.latch.countDown();
                try {
                    boolean gotPrestart = false;
                    while (true) {
                        block14: {
                            block13: {
                                ringItem = DataChannelImplFifo.this.getNextOutputRingItem(0);
                                pBankType = ringItem.getEventType();
                                pBankControlType = ringItem.getControlType();
                                if (pBankType != EventType.CONTROL) break block13;
                                if (pBankControlType == ControlType.PRESTART) {
                                    if (gotPrestart) {
                                        throw new EmuException("got 2 prestart events");
                                    }
                                    DataChannelImplFifo.this.logger.debug("      DataChannel Fifo: " + DataChannelImplFifo.this.name + " send prestart event");
                                    gotPrestart = true;
                                    this.writeEvioData(ringItem);
                                    break block14;
                                } else {
                                    if (!gotPrestart) {
                                        throw new EmuException("prestart, not " + (Object)((Object)pBankControlType) + ", must be first control event");
                                    }
                                    if (pBankControlType != ControlType.GO && pBankControlType != ControlType.END) {
                                        throw new EmuException("second control event must be go or end");
                                    }
                                    DataChannelImplFifo.this.logger.debug("      DataChannel Fifo: " + DataChannelImplFifo.this.name + " send " + (Object)((Object)pBankControlType) + " event");
                                    this.writeEvioData(ringItem);
                                    DataChannelImplFifo.this.releaseCurrentAndGoToNextOutputRingItem(0);
                                    if (pBankControlType == ControlType.END) {
                                        break;
                                    }
                                    break block12;
                                }
                            }
                            if (pBankType != EventType.USER) throw new EmuException((Object)((Object)pBankType) + " type of events must come after go event");
                            this.writeEvioData(ringItem);
                        }
                        DataChannelImplFifo.this.releaseCurrentAndGoToNextOutputRingItem(0);
                    }
                    System.out.println("      DataChannel Fifo: " + DataChannelImplFifo.this.name + " I got END event, quitting");
                    return;
                }
                catch (InterruptedException e) {
                    DataChannelImplFifo.this.logger.warn("      DataChannel Fifo: " + DataChannelImplFifo.this.name + "  interrupted thd, exiting");
                    return;
                }
                catch (Exception e) {
                    DataChannelImplFifo.this.channelState = CODAState.ERROR;
                    DataChannelImplFifo.this.emu.setErrorState("DataChannel fifo in: " + e.getMessage());
                    DataChannelImplFifo.this.logger.warn("      DataChannel Fifo: exit thd: " + e.getMessage());
                }
                return;
            }
            do {
                ringItem = DataChannelImplFifo.this.getNextOutputRingItem(DataChannelImplFifo.this.ringIndex);
                pBankType = ringItem.getEventType();
                pBankControlType = ringItem.getControlType();
                this.writeEvioData(ringItem);
                DataChannelImplFifo.this.releaseCurrentAndGoToNextOutputRingItem(DataChannelImplFifo.this.ringIndex);
                if (DataChannelImplFifo.this.outputRingCount > 1 && pBankControlType == null && !pBankType.isUser()) {
                    DataChannelImplFifo.this.setNextEventAndRing();
                }
                if (pBankControlType != ControlType.END) continue;
                DataChannelImplFifo.this.logger.info("      DataChannel Fifo: " + DataChannelImplFifo.this.name + " got END event, quitting 2");
                return;
            } while (!DataChannelImplFifo.this.gotResetCmd);
            DataChannelImplFifo.this.logger.info("      DataChannel Fifo: " + DataChannelImplFifo.this.name + " got RESET cmd, quitting");
        }
    }
}

