/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.messaging;

import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.emu.support.messaging.CMSGPortal;
import org.jlab.coda.emu.support.messaging.GenericCallback;

class MvalReportingHandler
extends GenericCallback
implements cMsgCallbackInterface {
    private int lowestM = Integer.MAX_VALUE;
    private int highestM = Integer.MIN_VALUE;
    private int highestSafeM = Integer.MIN_VALUE;
    private int totalEventsPerRoc;
    private final CMSGPortal cmsgPortal;
    private static final boolean debug = false;
    private long timeAtLastUpdate;

    MvalReportingHandler(CMSGPortal cmsgPortal) {
        this.cmsgPortal = cmsgPortal;
    }

    public void callback(cMsgMessage msg, Object o) {
        int val = msg.getUserInt();
        if (msg.getType().equalsIgnoreCase("M")) {
            long now;
            if (val < 1) {
                return;
            }
            if (val < this.lowestM) {
                this.lowestM = val;
            }
            if (val > this.highestM) {
                this.highestM = val;
            }
            if ((now = System.currentTimeMillis()) - this.timeAtLastUpdate >= 2000L) {
                if (this.highestSafeM != 2 * this.lowestM) {
                    this.highestSafeM = 2 * this.lowestM;
                    this.cmsgPortal.sendRocMessage(this.lowestM, this.highestM, this.highestSafeM);
                }
                this.lowestM = Integer.MAX_VALUE;
                this.highestM = Integer.MIN_VALUE;
                this.timeAtLastUpdate = now;
            }
        } else if (msg.getType().equalsIgnoreCase("eventsPerRoc")) {
            this.totalEventsPerRoc = msg.getUserInt();
            this.lowestM = Integer.MAX_VALUE;
            this.highestM = Integer.MIN_VALUE;
            this.highestSafeM = Integer.MIN_VALUE;
        }
    }
}

