/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.logger;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.jlab.coda.emu.support.logger.LoggerAppender;
import org.jlab.coda.emu.support.logger.LoggerDataWrapper;
import org.jlab.coda.emu.support.logger.LoggingEvent;
import org.jlab.coda.emu.support.logger.StdOutAppender;

public class Logger {
    private final String FQCN = Logger.class.getName();
    private final Set<String> fqcnSet = new HashSet<String>(8);
    private final Set<String> logFunctionsSet = new HashSet<String>(8);
    private boolean java13 = false;
    private final List<LoggerAppender> loggerAppenders = new Vector<LoggerAppender>(8);
    private boolean enable_debug = true;
    private boolean enable_error = true;

    public Logger() {
        this.fqcnSet.add(this.FQCN);
        this.addAppender(new StdOutAppender());
        this.logFunctionsSet.add("debug");
        this.logFunctionsSet.add("log");
        this.logFunctionsSet.add("error");
        this.logFunctionsSet.add("fatal");
        this.logFunctionsSet.add("info");
        this.logFunctionsSet.add("warn");
    }

    public void toggleDebug() {
        this.enable_debug = !this.enable_debug;
    }

    public void toggleError() {
        this.enable_error = !this.enable_error;
    }

    public boolean isDebugEnabled() {
        return this.enable_debug;
    }

    public boolean isErrorEnabled() {
        return this.enable_error;
    }

    private StackTraceElement getLocation(int level) {
        if (this.java13 || level < 13) {
            return null;
        }
        try {
            StackTraceElement[] ste = new Throwable().getStackTrace();
            boolean wrapperFound = false;
            for (int i = 0; i < ste.length - 1; ++i) {
                if (this.fqcnSet.contains(ste[i].getClassName())) {
                    wrapperFound = false;
                    String nextClassName = ste[i + 1].getClassName();
                    if (nextClassName.startsWith("java.") || nextClassName.startsWith("sun.") || this.fqcnSet.contains(nextClassName)) continue;
                    if (this.logFunctionsSet.contains(ste[i + 1].getMethodName())) {
                        wrapperFound = true;
                        continue;
                    }
                    if (nextClassName.startsWith("$Proxy")) {
                        return ste[i + 2];
                    }
                    return ste[i + 1];
                }
                if (!wrapperFound || this.logFunctionsSet.contains(ste[i].getMethodName())) continue;
                return ste[i];
            }
        }
        catch (Throwable e) {
            this.java13 = true;
        }
        return null;
    }

    private void write(int level, String message, Throwable throwable) {
        this.callAppenders(new LoggingEvent(level, message, this.getLocation(level), throwable));
    }

    private void write(int level, String message, Throwable throwable, Object data) {
        this.callAppenders(new LoggingEvent(level, message, this.getLocation(level), throwable, data));
    }

    private void write(int level, String message, Object data) {
        this.callAppenders(new LoggingEvent(level, message, null, null, data));
    }

    public void debug(String message) {
        if (this.enable_debug) {
            this.write(1, message, null);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.enable_debug) {
            this.write(1, message, t);
        }
    }

    public void debug(Throwable t) {
        if (this.enable_debug) {
            this.write(1, "error", t);
        }
    }

    public void debug(String message, String v) {
        if (this.enable_debug) {
            this.write(1, message, null, v);
        }
    }

    public void debug(String message, Object o) {
        if (this.enable_debug) {
            this.write(1, message, null, new LoggerDataWrapper(o));
        }
    }

    public void debug(String message, String v1, String v2) {
        if (this.enable_debug) {
            this.write(1, message, null, new LoggerDataWrapper(v1, v2));
        }
    }

    public void debug(String message, long v) {
        if (this.enable_debug) {
            this.write(1, message, null, new LoggerDataWrapper(v));
        }
    }

    public void debug(String message, long v1, long v2) {
        if (this.enable_debug) {
            this.write(1, message, null, new LoggerDataWrapper(v1, v2));
        }
    }

    public void debug(String message, boolean v) {
        if (this.enable_debug) {
            this.write(1, message, null, new LoggerDataWrapper(v));
        }
    }

    public void debugClassLoader(String message, Object obj) {
        Class<?> klass;
        if (obj == null) {
            this.write(1, message + " no class, no object", null, null);
            return;
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(message).append(' ');
        if (obj instanceof Class) {
            klass = (Class<?>)obj;
            buf.append("class ");
        } else {
            klass = obj.getClass();
            buf.append("instance ");
        }
        buf.append(klass.getName()).append(" loaded by ");
        if (klass.getClassLoader() != null) {
            buf.append(klass.getClassLoader().hashCode());
            buf.append(' ');
            buf.append(klass.getClassLoader().getClass().getName());
        } else {
            buf.append("system");
        }
        this.write(1, buf.toString(), null, null);
    }

    public void info(String message) {
        if (this.enable_error) {
            this.write(2, message, null);
        }
    }

    public void info(String message, String data) {
        if (this.enable_error) {
            this.write(2, message, null, data);
        }
    }

    public void warn(String message) {
        if (this.enable_error) {
            this.write(8, message, null);
        }
    }

    public void error(String message) {
        if (this.enable_error) {
            this.write(11, message, null);
        }
    }

    public void error(String message, long v) {
        if (this.enable_error) {
            this.write(11, message, null, new LoggerDataWrapper(v));
        }
    }

    public void error(String message, String v) {
        if (this.enable_error) {
            this.write(11, message, null, v);
        }
    }

    public void error(String message, String v, Throwable t) {
        if (this.enable_error) {
            this.write(11, message, t, v);
        }
    }

    public void error(Throwable t) {
        if (this.enable_error) {
            this.write(11, t.toString(), t);
        }
    }

    public void error(String message, Throwable t) {
        if (this.enable_error) {
            this.write(11, message + ' ' + t.toString(), t);
        }
    }

    public void rcConsole(String message, String severityText) {
        if (this.enable_error) {
            this.write(15, message, severityText);
        }
    }

    private void callAppenders(LoggingEvent event) {
        for (LoggerAppender a : this.loggerAppenders) {
            a.append(event);
        }
    }

    public void addLogOrigin(Class origin) {
        this.fqcnSet.add(origin.getName());
    }

    public void addAppender(LoggerAppender newAppender) {
        this.loggerAppenders.add(newAppender);
    }

    public void removeAppender(LoggerAppender appender) {
        this.loggerAppenders.remove(appender);
    }
}

