/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

public enum ControlType {
    SYNC(65488, 0),
    PRESTART(65489, 1),
    GO(65490, 2),
    PAUSE(65491, 3),
    END(65492, 4);

    private int value;
    private int ordinalValue;
    private static ControlType[] intToType;

    public static ControlType getControlType(int val) {
        if (val > 65492 || val < 65488) {
            return null;
        }
        return intToType[val & 0xF];
    }

    public static ControlType getControlTypeFromOrdinal(int val) {
        if (val > 4 || val < 0) {
            return null;
        }
        return intToType[val];
    }

    public static String getName(int val) {
        if (val > 65492 || val < 65488) {
            return null;
        }
        ControlType type = ControlType.getControlType(val);
        if (type == null) {
            return null;
        }
        return type.name();
    }

    private ControlType(int value, int ordinalValue) {
        this.value = value;
        this.ordinalValue = ordinalValue;
    }

    public int getValue() {
        return this.value;
    }

    public int getOrdinalValue() {
        return this.ordinalValue;
    }

    public static boolean isControl(int value) {
        return ControlType.getControlType(value) != null;
    }

    public boolean isPrestart() {
        return this == PRESTART;
    }

    public static boolean isPrestart(int value) {
        ControlType cType = ControlType.getControlType(value);
        return cType != null && cType == PRESTART;
    }

    public boolean isGo() {
        return this == GO;
    }

    public static boolean isGo(int value) {
        ControlType cType = ControlType.getControlType(value);
        return cType != null && cType == GO;
    }

    public boolean isPause() {
        return this.equals((Object)PAUSE);
    }

    public static boolean isPause(int value) {
        ControlType cType = ControlType.getControlType(value);
        return cType != null && cType == PRESTART;
    }

    public boolean isEnd() {
        return this == END;
    }

    public static boolean isEnd(int value) {
        ControlType cType = ControlType.getControlType(value);
        return cType != null && cType == END;
    }

    public boolean isSync() {
        return this == SYNC;
    }

    public static boolean isSync(int value) {
        ControlType cType = ControlType.getControlType(value);
        return cType != null && cType == SYNC;
    }

    static {
        intToType = new ControlType[16];
        ControlType[] controlTypeArray = ControlType.values();
        int n = controlTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ControlType type;
            ControlType.intToType[type.ordinalValue] = type = controlTypeArray[i];
        }
    }
}

