/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.data;

public enum CODATag {
    RAW_TRIGGER(65296),
    RAW_TRIGGER_TS(65297),
    RAW_TRIGGER_TS_BIG(65298),
    BUILT_TRIGGER_BANK(65312),
    BUILT_TRIGGER_TS(65313),
    BUILT_TRIGGER_RUN(65314),
    BUILT_TRIGGER_TS_RUN(65315),
    BUILT_TRIGGER_NRSD(65316),
    BUILT_TRIGGER_TS_NRSD(65317),
    BUILT_TRIGGER_RUN_NRSD(65318),
    BUILT_TRIGGER_TS_RUN_NRSD(65319),
    BUILT_TRIGGER_ROC_ERROR(65359),
    BUILT_BY_PEB(65360),
    BUILT_BY_PEB_SYNC(65368),
    BUILT_BY_SEB(65392),
    BUILT_BY_SEB_SYNC(65400);

    private int value;
    private static CODATag[] intToType;

    public static CODATag getTagType(int val) {
        if (val > 65393 || val < 65296) {
            return null;
        }
        return intToType[val & 0xFF];
    }

    public static String getName(int val) {
        if (val > 65393 || val < 65296) {
            return null;
        }
        CODATag type = CODATag.getTagType(val);
        if (type == null) {
            return null;
        }
        return type.name();
    }

    private CODATag(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isBuiltTrigger() {
        return this.value >= 65312 && this.value <= 65319;
    }

    public static boolean isBuiltTrigger(int value) {
        return value >= 65312 && value <= 65319;
    }

    public boolean isRawTrigger() {
        return this.value >= 65296 && this.value <= 65298;
    }

    public static boolean isRawTrigger(int value) {
        return value >= 65296 && value <= 65298;
    }

    public static boolean isTrigger(int value) {
        return value >= 65296 && value <= 65319;
    }

    public boolean isTrigger() {
        return this.value >= 65296 && this.value <= 65319;
    }

    public boolean hasTimestamp() {
        return this == RAW_TRIGGER_TS || this == RAW_TRIGGER_TS_BIG || this == BUILT_TRIGGER_TS || this == BUILT_TRIGGER_TS_RUN || this == BUILT_TRIGGER_TS_NRSD || this == BUILT_TRIGGER_TS_RUN_NRSD;
    }

    public static boolean hasTimestamp(int value) {
        return value == CODATag.RAW_TRIGGER_TS.value || value == CODATag.RAW_TRIGGER_TS_BIG.value || value == CODATag.BUILT_TRIGGER_TS.value || value == CODATag.BUILT_TRIGGER_TS_RUN.value || value == CODATag.BUILT_TRIGGER_TS_NRSD.value || value == CODATag.BUILT_TRIGGER_TS_RUN_NRSD.value;
    }

    public boolean hasRunData() {
        return this == BUILT_TRIGGER_RUN || this == BUILT_TRIGGER_TS_RUN || this == BUILT_TRIGGER_RUN_NRSD || this == BUILT_TRIGGER_TS_RUN_NRSD;
    }

    public static boolean hasRunData(int value) {
        return value == CODATag.BUILT_TRIGGER_RUN.value || value == CODATag.BUILT_TRIGGER_TS_RUN.value || value == CODATag.BUILT_TRIGGER_RUN_NRSD.value || value == CODATag.BUILT_TRIGGER_TS_RUN_NRSD.value;
    }

    public boolean hasRocSpecificData() {
        return this != BUILT_TRIGGER_NRSD && this != BUILT_TRIGGER_TS_NRSD && this != BUILT_TRIGGER_RUN_NRSD && this != BUILT_TRIGGER_TS_RUN_NRSD;
    }

    public static boolean hasRocSpecificData(int value) {
        return value != CODATag.BUILT_TRIGGER_NRSD.value && value != CODATag.BUILT_TRIGGER_TS_NRSD.value && value != CODATag.BUILT_TRIGGER_RUN_NRSD.value && value != CODATag.BUILT_TRIGGER_TS_RUN_NRSD.value;
    }

    public static boolean isSyncEVent(int value) {
        return value == CODATag.BUILT_BY_PEB_SYNC.value || value == CODATag.BUILT_BY_SEB_SYNC.value;
    }

    public boolean isSyncEVent() {
        return this == BUILT_BY_PEB_SYNC || this == BUILT_BY_SEB_SYNC;
    }

    static {
        intToType = new CODATag[256];
        CODATag[] cODATagArray = CODATag.values();
        int n = cODATagArray.length;
        for (int i = 0; i < n; ++i) {
            CODATag type;
            CODATag.intToType[type.value & 0xFF] = type = cODATagArray[i];
        }
    }
}

