/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.RingBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuEventNotify;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.data.Statistics;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.transport.DataChannel;

public class ModuleAdapter
implements EmuModule {
    protected int id;
    protected int eventProducingThreads;
    protected boolean epThreadsSetInConfig;
    protected final String name;
    protected AtomicReference<String> errorMsg = new AtomicReference();
    protected final Emu emu;
    protected final Logger logger;
    protected volatile CODAStateIF moduleState = CODAState.BOOTED;
    protected final Map<String, String> attributeMap;
    protected ArrayList<DataChannel> inputChannels = new ArrayList(16);
    protected ArrayList<DataChannel> outputChannels = new ArrayList(4);
    protected int inputChannelCount;
    protected int outputChannelCount;
    protected boolean paused;
    protected EmuEventNotify endCallback;
    protected EmuEventNotify prestartCallback;
    protected ByteOrder outputOrder;
    protected int[] inputChanLevels;
    protected int[] outputChanLevels;
    protected String[] inputChanNames;
    protected String[] outputChanNames;
    protected long eventCountTotal;
    protected long wordCountTotal;
    protected float eventRate;
    protected float wordRate;
    protected int maxEventSize;
    protected int minEventSize;
    protected int avgEventSize;
    protected int goodChunk_X_EtBufSize;
    protected int[] timeToBuild;
    protected static final int statGatheringPeriod = 2000;
    protected boolean representStatistics;
    protected boolean timeStatsOn;
    protected Statistics statistics;
    protected Thread RateCalculator;

    public ModuleAdapter(String name, Emu emu) {
        this.emu = emu;
        this.name = name;
        this.logger = null;
        this.attributeMap = null;
    }

    public ModuleAdapter(String name, Map<String, String> attributeMap, Emu emu) {
        this.emu = emu;
        this.name = name;
        this.attributeMap = attributeMap;
        this.logger = emu.getLogger();
        try {
            this.id = Integer.parseInt(attributeMap.get("id"));
            if (this.id < 0) {
                this.id = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        emu.setCodaid(this.id);
        this.eventProducingThreads = 1;
        try {
            this.eventProducingThreads = Integer.parseInt(attributeMap.get("threads"));
            if (this.eventProducingThreads < 1) {
                this.eventProducingThreads = 1;
            } else {
                this.epThreadsSetInConfig = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.outputOrder = ByteOrder.BIG_ENDIAN;
        String str = attributeMap.get("endian");
        if (str != null && str.equalsIgnoreCase("little")) {
            this.outputOrder = ByteOrder.LITTLE_ENDIAN;
        }
        this.logger.info("  Module Adapter: output byte order = " + this.outputOrder);
        this.representStatistics = true;
        str = attributeMap.get("repStats");
        if (str != null && (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("off") || str.equalsIgnoreCase("no"))) {
            this.representStatistics = false;
        }
        this.timeStatsOn = false;
        str = attributeMap.get("timeStats");
        if (str != null && (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("on") || str.equalsIgnoreCase("yes"))) {
            this.timeStatsOn = true;
        }
    }

    protected void eventToOutputChannel(RingItem itemOut, int channelNum, int ringNum) throws InterruptedException {
        if (this.outputChannelCount < 1) {
            itemOut.releaseByteBuffer();
            return;
        }
        RingBuffer<RingItem> rb = this.outputChannels.get(channelNum).getRingBuffersOut()[ringNum];
        long nextRingItem = rb.nextIntr(1);
        RingItem ri = (RingItem)rb.get(nextRingItem);
        ri.copy(itemOut);
        rb.publish(nextRingItem);
    }

    protected void eventToOutputChannel(RingItem itemOut, DataChannel channel, int ringNum) throws InterruptedException {
        if (this.outputChannelCount < 1) {
            itemOut.releaseByteBuffer();
            return;
        }
        RingBuffer<RingItem> rb = channel.getRingBuffersOut()[ringNum];
        long nextRingItem = rb.nextIntr(1);
        RingItem ri = (RingItem)rb.get(nextRingItem);
        ri.copy(itemOut);
        rb.publish(nextRingItem);
    }

    @Override
    public String[] getInputNames() {
        return this.inputChanNames;
    }

    @Override
    public String[] getOutputNames() {
        return this.outputChanNames;
    }

    @Override
    public int[] getOutputLevels() {
        if (this.outputChanLevels != null) {
            int i = 0;
            for (DataChannel chan : this.outputChannels) {
                this.outputChanLevels[i++] = chan.getOutputLevel();
            }
        }
        return this.outputChanLevels;
    }

    @Override
    public int[] getInputLevels() {
        if (this.inputChanLevels != null) {
            int i = 0;
            for (DataChannel chan : this.inputChannels) {
                this.inputChanLevels[i++] = chan.getInputLevel();
            }
        }
        return this.inputChanLevels;
    }

    @Override
    public void go() throws CmdExecException {
        this.moduleState = CODAState.ACTIVE;
    }

    @Override
    public void end() throws CmdExecException {
        this.moduleState = CODAState.DOWNLOADED;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void prestart() throws CmdExecException {
        this.moduleState = CODAState.PAUSED;
    }

    @Override
    public void download() throws CmdExecException {
        this.moduleState = CODAState.DOWNLOADED;
    }

    @Override
    public void reset() {
        this.moduleState = CODAState.CONFIGURED;
    }

    @Override
    public void registerEndCallback(EmuEventNotify callback) {
        this.endCallback = callback;
    }

    @Override
    public EmuEventNotify getEndCallback() {
        return this.endCallback;
    }

    @Override
    public void registerPrestartCallback(EmuEventNotify callback) {
        this.prestartCallback = callback;
    }

    @Override
    public EmuEventNotify getPrestartCallback() {
        return this.prestartCallback;
    }

    @Override
    public CODAStateIF state() {
        return this.moduleState;
    }

    @Override
    public String getError() {
        return this.errorMsg.get();
    }

    @Override
    public String getAttr(String name) throws DataNotFoundException {
        String attribute = this.attributeMap.get(name);
        if (attribute == null) {
            throw new DataNotFoundException("attribute " + name + " not found in config for " + this.name());
        }
        return attribute;
    }

    @Override
    public int getIntAttr(String name) throws DataNotFoundException, NumberFormatException {
        return Integer.valueOf(this.getAttr(name));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int getInternalRingCount() {
        return 0;
    }

    @Override
    public boolean representsEmuStatistics() {
        return this.representStatistics;
    }

    @Override
    public synchronized Object[] getStatistics() {
        Object[] stats = new Object[9];
        if (this.moduleState != CODAState.ACTIVE) {
            stats[0] = this.eventCountTotal;
            stats[1] = this.wordCountTotal;
            stats[2] = Float.valueOf(0.0f);
            stats[3] = Float.valueOf(0.0f);
            stats[4] = this.maxEventSize;
            stats[5] = this.minEventSize;
            stats[6] = this.avgEventSize;
            stats[7] = this.goodChunk_X_EtBufSize;
            stats[8] = this.timeToBuild;
        } else {
            if (this.timeStatsOn && this.statistics != null) {
                this.timeToBuild = this.statistics.fillHistogram();
            }
            stats[0] = this.eventCountTotal;
            stats[1] = this.wordCountTotal;
            stats[2] = Float.valueOf(this.eventRate);
            stats[3] = Float.valueOf(this.wordRate);
            stats[4] = this.maxEventSize;
            stats[5] = this.minEventSize;
            stats[6] = this.avgEventSize;
            stats[7] = this.goodChunk_X_EtBufSize;
            stats[8] = this.timeToBuild;
        }
        return stats;
    }

    @Override
    public void adjustStatistics(long eventsAdded, long wordsAdded) {
        this.eventCountTotal += eventsAdded;
        this.wordCountTotal += wordsAdded;
    }

    @Override
    public void addInputChannels(ArrayList<DataChannel> input_channels) {
        if (input_channels == null) {
            return;
        }
        this.inputChannels.addAll(input_channels);
        this.inputChannelCount = this.inputChannels.size();
    }

    @Override
    public void addOutputChannels(ArrayList<DataChannel> output_channels) {
        if (output_channels == null) {
            return;
        }
        this.outputChannels.addAll(output_channels);
        this.outputChannelCount = this.outputChannels.size();
    }

    @Override
    public ArrayList<DataChannel> getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public ArrayList<DataChannel> getOutputChannels() {
        return this.outputChannels;
    }

    @Override
    public void clearChannels() {
        this.inputChannels.clear();
        this.outputChannels.clear();
        this.outputChannelCount = 0;
        this.inputChannelCount = 0;
        this.outputChanLevels = null;
        this.outputChanNames = null;
        this.inputChanLevels = null;
        this.inputChanNames = null;
    }

    @Override
    public int getEventProducingThreadCount() {
        return this.eventProducingThreads;
    }

    @Override
    public ByteOrder getOutputOrder() {
        return this.outputOrder;
    }

    final class RateCalculatorThread
    extends Thread {
        RateCalculatorThread() {
        }

        @Override
        public void run() {
            long prevEventCount = 0L;
            long prevWordCount = 0L;
            while (ModuleAdapter.this.moduleState == CODAState.ACTIVE || ModuleAdapter.this.paused) {
                try {
                    RateCalculatorThread.sleep(2000L);
                    long t1 = System.currentTimeMillis();
                    while (ModuleAdapter.this.moduleState == CODAState.ACTIVE) {
                        RateCalculatorThread.sleep(2000L);
                        long t2 = System.currentTimeMillis();
                        long deltaT = t2 - t1;
                        ModuleAdapter.this.eventRate = (float)(ModuleAdapter.this.eventCountTotal - prevEventCount) * 1000.0f / (float)deltaT;
                        ModuleAdapter.this.wordRate = (float)(ModuleAdapter.this.wordCountTotal - prevWordCount) * 1000.0f / (float)deltaT;
                        prevEventCount = ModuleAdapter.this.eventCountTotal;
                        prevWordCount = ModuleAdapter.this.wordCountTotal;
                        t1 = t2;
                    }
                }
                catch (InterruptedException e) {
                    ModuleAdapter.this.logger.info("  Module Adapter: rate calculating thread for " + ModuleAdapter.this.name() + " exiting");
                    return;
                }
            }
        }
    }
}

