/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.PayloadBuffer;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.TransportType;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;

public class EventRecording
extends ModuleAdapter {
    private Thread recordingThread;
    private DataChannel mainInputChannel;
    private DataChannel etInputChannel;
    private DataChannel etOutputChannel;
    private DataChannel[] fileOutputChannels;
    private RingItem[] outputEvents;
    private int fileOutChannelCount;
    private int etOutChannelCount;
    private int mainIndex;
    private int etIndex;
    private boolean singleInput;
    private volatile boolean haveEndEvent;
    private long endingTimeLimit = 30000L;
    private int prescale;
    private boolean debug = false;
    private RingBuffer<RingItem>[] ringBuffersIn;
    private int[] ringBufferSizes;
    public Sequence[] sequencesIn;
    public SequenceBarrier[] barriersIn;

    public EventRecording(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
    }

    @Override
    public void clearChannels() {
        this.inputChannels.clear();
        this.outputChannels.clear();
    }

    private void startThreads() {
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.RateCalculator = new Thread(this.emu.getThreadGroup(), new ModuleAdapter.RateCalculatorThread(this), this.name + ":watcher");
        if (this.RateCalculator.getState() == Thread.State.NEW) {
            this.RateCalculator.start();
        }
        this.recordingThread = this.singleInput ? new RecordingThreadOneToMany(this.emu.getThreadGroup(), this.name + ":recorder") : new RecordingThreadTwoToMany(this.emu.getThreadGroup(), this.name + ":recorder");
        this.recordingThread.start();
    }

    private void interruptThreads(boolean end) {
        if (end && !this.haveEndEvent) {
            System.out.println("  ER mod: will end thread but no END event!");
            this.moduleState = CODAState.ERROR;
            this.emu.setErrorState("ER will end thread but no END event");
        }
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        if (this.recordingThread != null) {
            this.recordingThread.interrupt();
        }
    }

    private void joinThreads() {
        if (this.RateCalculator != null) {
            try {
                this.RateCalculator.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.recordingThread != null) {
            try {
                this.recordingThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void copyAndSwapUserEvent(PayloadBuffer buildingBank) {
        ByteBuffer buffy = buildingBank.getBuffer();
        EvioNode inputNode = buildingBank.getNode();
        if (this.outputOrder != buildingBank.getByteOrder()) {
            try {
                if (buffy != null) {
                    ByteDataTransformer.swapEvent((ByteBuffer)buffy, (ByteBuffer)buffy, (int)0, (int)0, (boolean)false, null);
                } else if (inputNode != null) {
                    buffy = inputNode.getStructureBuffer(true);
                    ByteDataTransformer.swapEvent((ByteBuffer)buffy, null, (int)0, (int)0, (boolean)false, null);
                    buildingBank.setBuffer(buffy);
                }
            }
            catch (EvioException evioException) {}
        } else if (buffy == null) {
            buffy = inputNode.getStructureBuffer(true);
            buildingBank.setBuffer(buffy);
        }
        buildingBank.setNode(null);
        buildingBank.releaseByteBuffer();
    }

    @Override
    public void reset() {
        Date theDate = new Date();
        CODAStateIF previousState = this.moduleState;
        this.moduleState = CODAState.CONFIGURED;
        this.interruptThreads(false);
        this.joinThreads();
        this.RateCalculator = null;
        this.recordingThread = null;
        this.paused = false;
        if (previousState.equals(CODAState.ACTIVE)) {
            try {
                Configurer.setValue(this.emu.parameters(), "status/run_end_time", theDate.toString());
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void go() {
        this.moduleState = CODAState.ACTIVE;
        this.paused = false;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void end() {
        this.moduleState = CODAState.DOWNLOADED;
        this.interruptThreads(true);
        this.joinThreads();
        this.RateCalculator = null;
        this.recordingThread = null;
        this.paused = false;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_end_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void prestart() throws CmdExecException {
        this.moduleState = CODAState.PAUSED;
        this.paused = true;
        if (this.inputChannelCount != 1 && this.inputChannelCount != 2) {
            this.moduleState = CODAState.ERROR;
            this.emu.setErrorState("ER must have at least 1 and no more than 2 input channels, not " + this.inputChannelCount);
            return;
        }
        if (this.inputChannels.size() == 1) {
            this.singleInput = true;
        }
        this.inputChanLevels = new int[this.inputChannelCount];
        this.inputChanNames = new String[this.inputChannelCount];
        this.outputChanLevels = new int[this.outputChannelCount];
        this.outputChanNames = new String[this.outputChannelCount];
        int indx = 0;
        this.etIndex = 0;
        this.mainIndex = 0;
        this.etInputChannel = null;
        this.mainInputChannel = null;
        this.etOutChannelCount = 0;
        this.fileOutChannelCount = 0;
        this.ringBuffersIn = new RingBuffer[this.inputChannelCount];
        this.ringBufferSizes = new int[this.inputChannelCount];
        this.sequencesIn = new Sequence[this.inputChannelCount];
        this.barriersIn = new SequenceBarrier[this.inputChannelCount];
        this.outputEvents = new RingItem[this.outputChannelCount];
        try {
            for (DataChannel ch : this.inputChannels) {
                if (ch.getTransportType() == TransportType.ET) {
                    if (this.singleInput) {
                        this.mainInputChannel = ch;
                        this.mainIndex = indx;
                    } else {
                        this.etInputChannel = ch;
                        this.etIndex = indx;
                        ch.getEndCallback().endWait();
                    }
                } else {
                    this.mainInputChannel = ch;
                    this.mainIndex = indx;
                }
                this.inputChanNames[indx] = ch.name();
                this.ringBuffersIn[indx] = ch.getRingBufferIn();
                this.ringBufferSizes[indx] = this.ringBuffersIn[indx].getBufferSize();
                this.sequencesIn[indx] = new Sequence(-1L);
                this.ringBuffersIn[indx].addGatingSequences(new Sequence[]{this.sequencesIn[indx]});
                this.barriersIn[indx] = this.ringBuffersIn[indx].newBarrier(new Sequence[0]);
                ++indx;
            }
            if (this.inputChannelCount == 2 && (this.etInputChannel == null || this.mainInputChannel == null)) {
                throw new CmdExecException("For 2 input channels, must have 1 ET & 1 EMU");
            }
            indx = 0;
            for (DataChannel ch : this.outputChannels) {
                if (ch.getTransportType() == TransportType.ET) {
                    this.etOutputChannel = ch;
                    ++this.etOutChannelCount;
                    this.prescale = ch.getPrescale();
                } else if (ch.getTransportType() == TransportType.FILE) {
                    ++this.fileOutChannelCount;
                }
                this.outputChanNames[indx++] = ch.name();
            }
            if (this.fileOutChannelCount + this.etOutChannelCount != this.outputChannelCount) {
                throw new CmdExecException("Allow only ET and File output channels");
            }
            if (this.etOutChannelCount > 1) {
                throw new CmdExecException("Allow only 1 ET output channel");
            }
            if (this.fileOutChannelCount > 0) {
                this.fileOutputChannels = new DataChannel[this.fileOutChannelCount];
                indx = 0;
                for (DataChannel ch : this.outputChannels) {
                    if (ch.getTransportType() != TransportType.FILE) continue;
                    this.fileOutputChannels[indx++] = ch;
                }
            }
            this.wordRate = 0.0f;
            this.eventRate = 0.0f;
            this.wordCountTotal = 0L;
            this.eventCountTotal = 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.startThreads();
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", "--prestart--");
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    private class RecordingThreadTwoToMany
    extends Thread {
        RecordingThreadTwoToMany(ThreadGroup group, String name) {
            super(group, name);
        }

        @Override
        public void run() {
            RingItem ringItem = null;
            ControlType controlType = null;
            long counter = 0L;
            long timeBetweenSamples = 500L;
            int totalNumberEvents = 1;
            int wordCount = 0;
            int firstEventsWords = 0;
            PayloadBuffer prePrestartFirstEvent = null;
            boolean gotPrestart = false;
            boolean isPrestart = false;
            boolean mainItem = true;
            boolean isUser = false;
            boolean isControl = false;
            boolean isFirst = false;
            EventType pBankType = null;
            int fileIndex = 0;
            long physicsEventCounter = 0L;
            long mainAvailableSequence = -2L;
            long mainNextSequence = EventRecording.this.sequencesIn[EventRecording.this.mainIndex].get() + 1L;
            long etAvailableSequence = -2L;
            long etNextSequence = EventRecording.this.sequencesIn[EventRecording.this.etIndex].get() + 1L;
            long t1 = System.currentTimeMillis();
            while (EventRecording.this.moduleState == CODAState.ACTIVE || EventRecording.this.paused) {
                try {
                    long t2;
                    boolean gotBank = false;
                    if (mainAvailableSequence < mainNextSequence && etAvailableSequence < etNextSequence) {
                        try {
                            mainAvailableSequence = EventRecording.this.barriersIn[EventRecording.this.mainIndex].waitFor(mainNextSequence);
                        }
                        catch (TimeoutException timeoutException) {
                            // empty catch block
                        }
                        if (!EventRecording.this.singleInput && EventRecording.this.ringBuffersIn[EventRecording.this.etIndex].getCursor() >= etNextSequence) {
                            etAvailableSequence = EventRecording.this.barriersIn[EventRecording.this.etIndex].waitFor(etNextSequence);
                        }
                    }
                    if ((t2 = EventRecording.this.emu.getTime()) - t1 > 500L) {
                        EventRecording.this.inputChanLevels[((EventRecording)EventRecording.this).mainIndex] = ((int)(EventRecording.this.ringBuffersIn[EventRecording.this.mainIndex].getCursor() - EventRecording.this.ringBuffersIn[EventRecording.this.mainIndex].getMinimumGatingSequence()) + 1) * 100 / EventRecording.this.ringBufferSizes[EventRecording.this.mainIndex];
                        EventRecording.this.inputChanLevels[((EventRecording)EventRecording.this).etIndex] = ((int)(EventRecording.this.ringBuffersIn[EventRecording.this.etIndex].getCursor() - EventRecording.this.ringBuffersIn[EventRecording.this.etIndex].getMinimumGatingSequence()) + 1) * 100 / EventRecording.this.ringBufferSizes[EventRecording.this.etIndex];
                        t1 = t2;
                    }
                    while (mainNextSequence <= mainAvailableSequence || etNextSequence <= etAvailableSequence) {
                        if (etNextSequence <= etAvailableSequence) {
                            ringItem = (RingItem)EventRecording.this.ringBuffersIn[EventRecording.this.etIndex].get(etNextSequence);
                            mainItem = false;
                        } else {
                            ringItem = (RingItem)EventRecording.this.ringBuffersIn[EventRecording.this.mainIndex].get(mainNextSequence);
                            mainItem = true;
                        }
                        wordCount = ringItem.getTotalBytes() / 4;
                        controlType = ringItem.getControlType();
                        totalNumberEvents = ringItem.getEventCount();
                        pBankType = ringItem.getEventType();
                        isControl = pBankType.isControl();
                        isUser = pBankType.isUser();
                        isFirst = ringItem.isFirstEvent();
                        if (isControl) {
                            if (!mainItem) {
                                System.out.println("  ER mod: reject " + (Object)((Object)controlType) + " event from ET input channel, release seq " + etNextSequence);
                                ringItem.releaseByteBuffer();
                                EventRecording.this.sequencesIn[EventRecording.this.etIndex].set(etNextSequence++);
                                continue;
                            }
                            System.out.println("  ER mod: got control event, " + (Object)((Object)controlType));
                            if (controlType.isPrestart()) {
                                EventRecording.this.prestartCallback.endWait();
                                if (gotPrestart) {
                                    throw new EmuException("got 2 prestart events");
                                }
                                gotPrestart = true;
                                isPrestart = true;
                                wordCount = 5 + firstEventsWords;
                                totalNumberEvents = 1;
                                if (prePrestartFirstEvent != null) {
                                    ++totalNumberEvents;
                                }
                            } else {
                                if (!gotPrestart) {
                                    throw new EmuException("prestart, not " + (Object)((Object)controlType) + ", must be first control event");
                                }
                                if (controlType != ControlType.GO && controlType != ControlType.END) {
                                    throw new EmuException("second control event must be go or end");
                                }
                            }
                        }
                        if (!gotPrestart) {
                            if (isFirst) {
                                prePrestartFirstEvent = (PayloadBuffer)((PayloadBuffer)ringItem).clone();
                                firstEventsWords = wordCount;
                                if (prePrestartFirstEvent.getBuffer() == null) {
                                    prePrestartFirstEvent.setBuffer(ringItem.getNode().getStructureBuffer(true));
                                    prePrestartFirstEvent.setNode(null);
                                }
                                System.out.println("  ER mod: SET \"first event\" of type " + (Object)((Object)pBankType) + " which arrived before PRESTART event");
                            } else {
                                System.out.println("  ER mod: THROWING AWAY event of type " + (Object)((Object)pBankType) + " which arrived before PRESTART event");
                            }
                            ringItem.releaseByteBuffer();
                            if (mainItem) {
                                EventRecording.this.sequencesIn[EventRecording.this.mainIndex].set(mainNextSequence++);
                                continue;
                            }
                            EventRecording.this.sequencesIn[EventRecording.this.etIndex].set(etNextSequence++);
                            continue;
                        }
                        gotBank = true;
                        break;
                    }
                    if (!gotBank) continue;
                    if (EventRecording.this.outputChannelCount > 0) {
                        if (isControl || isFirst) {
                            int j;
                            int i;
                            if (isFirst) {
                                EventRecording.this.copyAndSwapUserEvent((PayloadBuffer)ringItem);
                            }
                            ((EventRecording)EventRecording.this).outputEvents[0] = ringItem;
                            for (i = 1; i < EventRecording.this.outputChannelCount; ++i) {
                                ((EventRecording)EventRecording.this).outputEvents[i] = new PayloadBuffer((PayloadBuffer)ringItem);
                            }
                            for (j = 0; j < EventRecording.this.outputChannelCount; ++j) {
                                System.out.println("  ER mod: writing control/first (seq " + mainNextSequence + '/' + etNextSequence + ") to channel " + EventRecording.this.fileOutputChannels[j].name());
                                EventRecording.this.eventToOutputChannel(EventRecording.this.outputEvents[j], j, 0);
                            }
                            if (isPrestart) {
                                if (prePrestartFirstEvent != null) {
                                    EventRecording.this.copyAndSwapUserEvent(prePrestartFirstEvent);
                                    ((EventRecording)EventRecording.this).outputEvents[0] = prePrestartFirstEvent;
                                    for (i = 1; i < EventRecording.this.outputChannelCount; ++i) {
                                        ((EventRecording)EventRecording.this).outputEvents[i] = new PayloadBuffer(prePrestartFirstEvent);
                                    }
                                    for (j = 0; j < EventRecording.this.outputChannelCount; ++j) {
                                        System.out.println("  ER mod: sending first event to chan " + ((DataChannel)EventRecording.this.outputChannels.get(j)).name());
                                        EventRecording.this.eventToOutputChannel(EventRecording.this.outputEvents[j], j, 0);
                                    }
                                }
                                isPrestart = false;
                            }
                        } else if (isUser) {
                            EventRecording.this.copyAndSwapUserEvent((PayloadBuffer)ringItem);
                            if (EventRecording.this.fileOutChannelCount > 0) {
                                EventRecording.this.eventToOutputChannel(ringItem, EventRecording.this.fileOutputChannels[0], 0);
                            } else if (EventRecording.this.etOutChannelCount > 0) {
                                EventRecording.this.eventToOutputChannel(ringItem, EventRecording.this.etOutputChannel, 0);
                            }
                        } else {
                            if (EventRecording.this.etOutChannelCount > 0 && physicsEventCounter++ % (long)EventRecording.this.prescale == 0L) {
                                PayloadBuffer bb = new PayloadBuffer((PayloadBuffer)ringItem);
                                EventRecording.this.eventToOutputChannel((RingItem)bb, EventRecording.this.etOutputChannel, 0);
                            }
                            EventRecording.this.eventToOutputChannel(ringItem, EventRecording.this.fileOutputChannels[fileIndex], 0);
                            fileIndex = (fileIndex + 1) % EventRecording.this.fileOutChannelCount;
                        }
                    }
                    EventRecording.this.eventCountTotal += (long)totalNumberEvents;
                    EventRecording.this.wordCountTotal += (long)wordCount;
                    if (controlType == ControlType.END) {
                        EventRecording.this.logger.info("  ER mod: found END event");
                        EventRecording.this.haveEndEvent = true;
                        if (EventRecording.this.endCallback != null) {
                            EventRecording.this.endCallback.endWait();
                        }
                        return;
                    }
                    if (EventRecording.this.outputChannelCount < 1) {
                        isPrestart = false;
                        prePrestartFirstEvent = null;
                        ringItem.releaseByteBuffer();
                    }
                    if (mainItem) {
                        EventRecording.this.sequencesIn[EventRecording.this.mainIndex].set(mainNextSequence++);
                        continue;
                    }
                    EventRecording.this.sequencesIn[EventRecording.this.etIndex].set(etNextSequence++);
                }
                catch (InterruptedException e) {
                    System.out.println("  ER mod: INTERRUPTED recording thread " + Thread.currentThread().getName());
                    return;
                }
                catch (AlertException e) {
                    System.out.println("  ER mod: ring buf alert");
                    EventRecording.this.moduleState = CODAState.ERROR;
                    EventRecording.this.emu.setErrorState("ER ring buf alert");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("  ER mod: MAJOR ERROR recording event: " + e.getMessage());
                    EventRecording.this.moduleState = CODAState.ERROR;
                    EventRecording.this.emu.setErrorState("ER MAJOR ERROR recording event: " + e.getMessage());
                    return;
                }
            }
            if (EventRecording.this.debug) {
                System.out.println("  ER mod: recording thread ending");
            }
        }
    }

    private class RecordingThreadOneToMany
    extends Thread {
        RecordingThreadOneToMany(ThreadGroup group, String name) {
            super(group, name);
        }

        @Override
        public void run() {
            RingItem ringItem = null;
            ControlType controlType = null;
            long counter = 0L;
            long timeBetweenSamples = 500L;
            int totalNumberEvents = 1;
            int wordCount = 0;
            int firstEventsWords = 0;
            PayloadBuffer firstEvent = null;
            boolean gotPrestart = false;
            boolean isPrestart = false;
            boolean isUser = false;
            boolean isControl = false;
            boolean isFirst = false;
            EventType pBankType = null;
            int fileIndex = 0;
            long physicsEventCounter = 0L;
            EventRecording.this.mainIndex = 0;
            long mainAvailableSequence = -2L;
            long mainNextSequence = EventRecording.this.sequencesIn[EventRecording.this.mainIndex].get() + 1L;
            long t1 = System.currentTimeMillis();
            while (EventRecording.this.moduleState == CODAState.ACTIVE || EventRecording.this.paused) {
                try {
                    long t2;
                    boolean gotBank = false;
                    if (mainAvailableSequence < mainNextSequence) {
                        try {
                            mainAvailableSequence = EventRecording.this.barriersIn[EventRecording.this.mainIndex].waitFor(mainNextSequence);
                        }
                        catch (TimeoutException e) {
                            continue;
                        }
                    }
                    if ((t2 = EventRecording.this.emu.getTime()) - t1 > 500L) {
                        EventRecording.this.inputChanLevels[((EventRecording)EventRecording.this).mainIndex] = ((int)(EventRecording.this.ringBuffersIn[EventRecording.this.mainIndex].getCursor() - EventRecording.this.ringBuffersIn[EventRecording.this.mainIndex].getMinimumGatingSequence()) + 1) * 100 / EventRecording.this.ringBufferSizes[EventRecording.this.mainIndex];
                        t1 = t2;
                    }
                    while (mainNextSequence <= mainAvailableSequence) {
                        ringItem = (RingItem)EventRecording.this.ringBuffersIn[EventRecording.this.mainIndex].get(mainNextSequence);
                        wordCount = ringItem.getTotalBytes() / 4;
                        controlType = ringItem.getControlType();
                        totalNumberEvents = ringItem.getEventCount();
                        pBankType = ringItem.getEventType();
                        isControl = pBankType.isControl();
                        isUser = pBankType.isUser();
                        isFirst = ringItem.isFirstEvent();
                        if (isControl) {
                            System.out.println("  ER mod: got control event, " + (Object)((Object)controlType));
                            if (controlType.isPrestart()) {
                                EventRecording.this.prestartCallback.endWait();
                                if (gotPrestart) {
                                    throw new EmuException("got 2 prestart events");
                                }
                                gotPrestart = true;
                                isPrestart = true;
                                wordCount = 5 + firstEventsWords;
                                totalNumberEvents = 1;
                                if (firstEvent != null) {
                                    ++totalNumberEvents;
                                }
                            } else {
                                if (!gotPrestart) {
                                    throw new EmuException("prestart, not " + (Object)((Object)controlType) + ", must be first control event");
                                }
                                if (controlType != ControlType.GO && controlType != ControlType.END) {
                                    throw new EmuException("second control event must be go or end");
                                }
                            }
                        }
                        if (!gotPrestart) {
                            if (ringItem.isFirstEvent()) {
                                firstEvent = (PayloadBuffer)((PayloadBuffer)ringItem).clone();
                                firstEventsWords = wordCount;
                                if (firstEvent.getBuffer() == null) {
                                    firstEvent.setBuffer(ringItem.getNode().getStructureBuffer(true));
                                    firstEvent.setNode(null);
                                }
                                System.out.println("  ER mod: SET \"first event\" of type " + (Object)((Object)ringItem.getEventType()) + " which arrived before PRESTART event");
                            } else {
                                System.out.println("  ER mod: THROWING AWAY event of type " + (Object)((Object)ringItem.getEventType()) + " which arrived before PRESTART event");
                            }
                            ringItem.releaseByteBuffer();
                            EventRecording.this.sequencesIn[EventRecording.this.mainIndex].set(mainNextSequence++);
                            continue;
                        }
                        gotBank = true;
                        break;
                    }
                    if (!gotBank) continue;
                    if (EventRecording.this.outputChannelCount > 0) {
                        if (isControl || isFirst) {
                            int j;
                            int i;
                            if (isFirst) {
                                EventRecording.this.copyAndSwapUserEvent((PayloadBuffer)ringItem);
                            }
                            ((EventRecording)EventRecording.this).outputEvents[0] = ringItem;
                            for (i = 1; i < EventRecording.this.outputChannelCount; ++i) {
                                ((EventRecording)EventRecording.this).outputEvents[i] = new PayloadBuffer((PayloadBuffer)ringItem);
                            }
                            for (j = 0; j < EventRecording.this.outputChannelCount; ++j) {
                                System.out.println("  ER mod: writing control/first (seq " + mainNextSequence + ") to channel " + EventRecording.this.fileOutputChannels[j].name());
                                EventRecording.this.eventToOutputChannel(EventRecording.this.outputEvents[j], j, 0);
                            }
                            if (isPrestart) {
                                if (firstEvent != null) {
                                    EventRecording.this.copyAndSwapUserEvent(firstEvent);
                                    ((EventRecording)EventRecording.this).outputEvents[0] = firstEvent;
                                    for (i = 1; i < EventRecording.this.outputChannelCount; ++i) {
                                        ((EventRecording)EventRecording.this).outputEvents[i] = new PayloadBuffer(firstEvent);
                                    }
                                    for (j = 0; j < EventRecording.this.outputChannelCount; ++j) {
                                        System.out.println("  ER mod: sending first event to chan " + ((DataChannel)EventRecording.this.outputChannels.get(j)).name());
                                        EventRecording.this.eventToOutputChannel(EventRecording.this.outputEvents[j], j, 0);
                                    }
                                }
                                isPrestart = false;
                            }
                        } else if (isUser) {
                            EventRecording.this.copyAndSwapUserEvent((PayloadBuffer)ringItem);
                            if (EventRecording.this.fileOutChannelCount > 0) {
                                EventRecording.this.eventToOutputChannel(ringItem, EventRecording.this.fileOutputChannels[0], 0);
                            } else if (EventRecording.this.etOutChannelCount > 0) {
                                EventRecording.this.eventToOutputChannel(ringItem, EventRecording.this.etOutputChannel, 0);
                            }
                        } else {
                            if (EventRecording.this.etOutChannelCount > 0 && physicsEventCounter++ % (long)EventRecording.this.prescale == 0L) {
                                PayloadBuffer bb = new PayloadBuffer((PayloadBuffer)ringItem);
                                EventRecording.this.eventToOutputChannel((RingItem)bb, EventRecording.this.etOutputChannel, 0);
                            }
                            EventRecording.this.eventToOutputChannel(ringItem, EventRecording.this.fileOutputChannels[fileIndex], 0);
                            fileIndex = (fileIndex + 1) % EventRecording.this.fileOutChannelCount;
                        }
                    }
                    EventRecording.this.eventCountTotal += (long)totalNumberEvents;
                    EventRecording.this.wordCountTotal += (long)wordCount;
                    if (controlType == ControlType.END) {
                        EventRecording.this.logger.info("  ER mod: found END event");
                        EventRecording.this.haveEndEvent = true;
                        if (EventRecording.this.endCallback != null) {
                            EventRecording.this.endCallback.endWait();
                        }
                        return;
                    }
                    if (EventRecording.this.outputChannelCount < 1) {
                        isPrestart = false;
                        firstEvent = null;
                        ringItem.releaseByteBuffer();
                    }
                    EventRecording.this.sequencesIn[EventRecording.this.mainIndex].set(mainNextSequence++);
                }
                catch (InterruptedException e) {
                    System.out.println("  ER mod: INTERRUPTED recording thread " + Thread.currentThread().getName());
                    return;
                }
                catch (AlertException e) {
                    System.out.println("  ER mod: ring buf alert");
                    EventRecording.this.moduleState = CODAState.ERROR;
                    EventRecording.this.emu.setErrorState("ER ring buf alert");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("  ER mod: MAJOR ERROR recording event: " + e.getMessage());
                    EventRecording.this.moduleState = CODAState.ERROR;
                    EventRecording.this.emu.setErrorState("ER MAJOR ERROR recording event: " + e.getMessage());
                    return;
                }
            }
            if (EventRecording.this.debug) {
                System.out.println("  ER mod: recording thread ending");
            }
        }
    }
}

