/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;

public class Dummy
extends ModuleAdapter {
    private boolean debug;
    private ArrayList<EventMovingThread> threadList = new ArrayList(4);
    private RingBuffer<RingItem>[] ringBuffersIn;
    public Sequence[][] buildSequenceIn;
    public SequenceBarrier[] buildBarrierIn;

    public Dummy(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
    }

    @Override
    public void reset() {
        if (this.debug) {
            System.out.println("  Dummy: reset");
        }
        this.moduleState = CODAState.CONFIGURED;
        this.paused = false;
        this.endThreads();
    }

    @Override
    public void end() throws CmdExecException {
        if (this.debug) {
            System.out.println("  Dummy: end");
        }
        this.moduleState = CODAState.DOWNLOADED;
        this.paused = false;
        this.endThreads();
    }

    @Override
    public void prestart() throws CmdExecException {
        int i;
        if (this.debug) {
            System.out.println("  Dummy: prestart");
        }
        this.moduleState = CODAState.PAUSED;
        this.ringBuffersIn = new RingBuffer[this.inputChannelCount];
        this.buildSequenceIn = new Sequence[this.eventProducingThreads][this.inputChannelCount];
        this.buildBarrierIn = new SequenceBarrier[this.inputChannelCount];
        for (i = 0; i < this.inputChannelCount; ++i) {
            RingBuffer<RingItem> rb = ((DataChannel)this.inputChannels.get(i)).getRingBufferIn();
            this.ringBuffersIn[i] = rb;
            this.buildBarrierIn[i] = rb.newBarrier(new Sequence[0]);
            for (int j = 0; j < this.eventProducingThreads; ++j) {
                this.buildSequenceIn[j][i] = new Sequence(-1L);
                rb.addGatingSequences(new Sequence[]{this.buildSequenceIn[j][i]});
            }
        }
        if (this.debug) {
            System.out.println("  Dummy: create & start event moving threads");
        }
        this.threadList.clear();
        for (i = 0; i < this.eventProducingThreads; ++i) {
            EventMovingThread thd1 = new EventMovingThread(i, this.emu.getThreadGroup(), this.name + ":moving" + i);
            this.threadList.add(thd1);
            thd1.start();
        }
        this.paused = true;
    }

    @Override
    public void pause() {
        if (this.debug) {
            System.out.println("Dummy: pause");
        }
        this.paused = true;
    }

    @Override
    public void go() throws CmdExecException {
        if (this.debug) {
            System.out.println("Dummy: go");
        }
        this.moduleState = CODAState.ACTIVE;
        this.paused = false;
    }

    private void endThreads() {
        for (Thread thread : this.threadList) {
            thread.interrupt();
            try {
                thread.join(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class EventMovingThread
    extends Thread {
        private final int order;
        private Sequence[] buildSequences;
        private long[] availableSequences;
        private long[] nextSequences;

        EventMovingThread(int order, ThreadGroup group, String name) {
            super(group, name);
            this.order = order;
        }

        @Override
        public void run() {
            int inputChan = -1;
            int outputChan = -1;
            this.nextSequences = new long[Dummy.this.inputChannelCount];
            this.availableSequences = new long[Dummy.this.inputChannelCount];
            Arrays.fill(this.availableSequences, -2L);
            this.buildSequences = new Sequence[Dummy.this.inputChannelCount];
            for (int i = 0; i < Dummy.this.inputChannelCount; ++i) {
                this.buildSequences[i] = Dummy.this.buildSequenceIn[this.order][i];
                this.nextSequences[i] = this.buildSequences[i].get() + 1L;
            }
            while (Dummy.this.moduleState == CODAState.ACTIVE || Dummy.this.paused) {
                try {
                    RingItem ringItem;
                    EventType eventType;
                    inputChan = (inputChan + 1) % Dummy.this.inputChannelCount;
                    if (this.availableSequences[inputChan] < this.nextSequences[inputChan]) {
                        this.availableSequences[inputChan] = Dummy.this.buildBarrierIn[inputChan].waitFor(this.nextSequences[inputChan]);
                    }
                    if (Dummy.this.debug) {
                        System.out.println("  Dummy: get input item, chan# " + inputChan);
                    }
                    if ((eventType = (ringItem = (RingItem)Dummy.this.ringBuffersIn[inputChan].get(this.nextSequences[inputChan])).getEventType()).isControl()) {
                        if (ringItem.getControlType().isEnd()) {
                            if (Dummy.this.endCallback != null) {
                                Dummy.this.endCallback.endWait();
                            }
                        } else if (ringItem.getControlType().isPrestart() && Dummy.this.prestartCallback != null) {
                            Dummy.this.prestartCallback.endWait();
                        }
                        return;
                    }
                    if (Dummy.this.outputChannelCount > 0) {
                        outputChan = (outputChan + 1) % Dummy.this.outputChannelCount;
                        if (Dummy.this.outputChannelCount > 0) {
                            if (Dummy.this.debug) {
                                System.out.println("  Dummy: output item");
                            }
                            Dummy.this.eventToOutputChannel(ringItem, outputChan, this.order);
                        }
                    } else {
                        ringItem.releaseByteBuffer();
                    }
                    int n = inputChan;
                    long l = this.nextSequences[n];
                    this.nextSequences[n] = l + 1L;
                    this.buildSequences[inputChan].set(l);
                }
                catch (InterruptedException e) {
                    System.out.println("  Dummy: interrupted, end build thread");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Dummy.this.emu.setErrorState(e.getMessage());
                    Dummy.this.moduleState = CODAState.ERROR;
                    return;
                }
            }
        }
    }
}

