/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test.blast;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.emu.EmuUtilities;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.CODATag;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriterUnsync;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.Utilities;

public class EmuBlaster2 {
    private String name = "EmuBlaster";
    private int id;
    private final int generatingThdId;
    private int myRocRecordId;
    private long myEventNumber;
    private long timestamp;
    private ByteBufferSupply bbSupply1;
    private ByteBufferSupply bbSupply2;
    private boolean direct;
    private ByteBuffer templateBuffer1;
    private ByteBuffer templateBuffer2;
    private ByteOrder outputOrder;
    private int generatedDataWords;
    private long eventCountTotal;
    private long byteCountTotal;
    private int eventProducingThreads;
    private volatile int rocRecordId;
    private int triggerType;
    private int eventBlockSize;
    private int detectorId;
    private int eventWordSize;
    private int eventSize;
    private int loops;
    private int bufferSize = 8192;
    private int sendBufferSize = 32768;
    private byte[] buffer;
    private int blasteePort = 22333;
    private String blasteeHost;
    private boolean noDelay;
    private int connectTimeout;
    private int socketCount = 1;
    private EventWriterUnsync writer1;
    private EventWriterUnsync writer2;
    int pCounter1 = 0;
    int pCounter2 = 0;

    private static void usage() {
        System.out.println("\nUsage:\n\n   java EmuBlaster\n         -h <host>        blastee host\n        [-d <buf size>]   writing data buffer size in bytes (8192)\n        [-s <buf size>]   TCP send buffer size in bytes (4*8192)\n        [-p <port>]       blastee TCP port (22333)\n        [-c <sockets>]    number of sockets used\n        [-nd]             no-delay socket option on (must be last option specified)\n        [-help]           print this message\n");
    }

    public static void main(String[] args) {
        try {
            EmuBlaster2 blaster = new EmuBlaster2(args);
            blaster.run();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public EmuBlaster2(String[] args) {
        this.decodeCommandLine(args);
        this.buffer = new byte[this.bufferSize];
        this.id = (int)System.currentTimeMillis() & 0x7FFFFFF;
        this.rocRecordId = 0;
        this.generatingThdId = 0;
        this.eventCountTotal = 0L;
        this.byteCountTotal = 0L;
        this.eventProducingThreads = 1;
        this.outputOrder = ByteOrder.BIG_ENDIAN;
        this.connectTimeout = 5;
        this.eventBlockSize = 20;
        this.eventSize = 40;
        this.triggerType = 15;
        this.detectorId = 111;
        this.myRocRecordId = this.rocRecordId + this.generatingThdId;
        this.myEventNumber = 1L + (long)(this.generatingThdId * this.eventBlockSize);
        this.timestamp = 0L;
        this.generatedDataWords = this.eventBlockSize * this.eventSize;
        this.eventWordSize = this.getSingleEventBufferWords(this.generatedDataWords);
        this.templateBuffer1 = this.createSingleEventBuffer(this.generatedDataWords, this.myEventNumber, this.timestamp);
        this.bbSupply1 = new ByteBufferSupply(16, this.bufferSize, this.outputOrder, this.direct);
        SocketSender sender1 = new SocketSender(this.bbSupply1, 1);
        sender1.start();
        if (this.socketCount == 2) {
            this.templateBuffer2 = EmuUtilities.deepCopy(this.templateBuffer1);
            this.bbSupply2 = new ByteBufferSupply(16, this.bufferSize, this.outputOrder, this.direct);
            SocketSender sender2 = new SocketSender(this.bbSupply2, 2);
            sender2.start();
        }
    }

    private void decodeCommandLine(String[] args) {
        boolean setSendBufSize = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-help")) {
                    EmuBlaster2.usage();
                    System.exit(-1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    this.blasteeHost = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    this.bufferSize = Integer.parseInt(args[i + 1]);
                    if (this.bufferSize < 1) {
                        System.out.println("Data buffer size must be > 0");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-s")) {
                    this.sendBufferSize = Integer.parseInt(args[i + 1]);
                    if (this.sendBufferSize < 1) {
                        System.out.println("TCP send buffer size must be > 0");
                        System.exit(1);
                    }
                    setSendBufSize = true;
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-p")) {
                    this.blasteePort = Integer.parseInt(args[i + 1]);
                    if (this.blasteePort < 1024 || this.blasteePort > 65535) {
                        System.out.println("Port must be > 1023 & < 65536");
                        System.exit(1);
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-c")) {
                    this.socketCount = Integer.parseInt(args[i + 1]);
                    if (this.socketCount != 1 && this.socketCount != 2) {
                        System.out.println("Socket count must be 1 or 2");
                    }
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-nd")) {
                    this.noDelay = true;
                    continue;
                }
                EmuBlaster2.usage();
                System.exit(-1);
            }
        }
        catch (Exception ex) {
            EmuBlaster2.usage();
            System.exit(-1);
        }
        if (this.blasteeHost == null) {
            System.out.println("\nNeed host specified on command line");
            EmuBlaster2.usage();
            System.exit(-1);
        }
        if (!setSendBufSize) {
            this.sendBufferSize = this.bufferSize <= 8192 ? 32768 : 4 * this.bufferSize;
        }
    }

    private int getSingleEventBufferWords(int generatedDataWords) {
        int dataWordLength = 1 + generatedDataWords;
        return 6 + 4 * this.eventBlockSize + dataWordLength;
    }

    private void setTimeStamp(ByteBuffer buf, long ts) {
        buf.putLong(24, ts);
    }

    private ByteBuffer createSingleEventBuffer(int generatedDataWords, long eventNumber, long timestamp) {
        int writeIndex = 0;
        int dataLen = 1 + generatedDataWords;
        ByteBuffer buf = ByteBuffer.allocate(4 * this.eventWordSize);
        buf.order(this.outputOrder);
        int rocTag = Evio.createCodaTag(false, false, true, false, this.id);
        int secondWord = rocTag << 16 | DataType.BANK.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, this.eventWordSize - 1);
        buf.putInt(writeIndex += 4, secondWord);
        secondWord = CODATag.RAW_TRIGGER_TS.getValue() << 16 | DataType.SEGMENT.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex += 4, this.eventWordSize - 2 - dataLen - 2 - 1);
        buf.putInt(writeIndex += 4, secondWord);
        writeIndex += 4;
        int segWord = this.triggerType << 24 | DataType.UINT32.getValue() << 16 | 3;
        for (int i = 0; i < this.eventBlockSize; ++i) {
            buf.putInt(writeIndex, segWord);
            buf.putInt(writeIndex += 4, (int)(eventNumber + (long)i));
            buf.putInt(writeIndex += 4, (int)timestamp);
            buf.putInt(writeIndex += 4, (int)(timestamp >>> 32 & 0xFFFFL));
            writeIndex += 4;
            timestamp += 4L;
        }
        int dataTag = Evio.createCodaTag(false, false, true, false, this.detectorId);
        secondWord = dataTag << 16 | DataType.UINT32.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, dataLen + 1);
        buf.putInt(writeIndex += 4, secondWord);
        buf.putInt(writeIndex += 4, (int)eventNumber);
        writeIndex += 4;
        for (int i = 0; i < generatedDataWords; ++i) {
            buf.putInt(writeIndex, 1);
            writeIndex += 4;
        }
        return buf;
    }

    public void run() {
        int skip = 2;
        int printPeriod = 5000;
        long oldVal = 0L;
        long totalT = 0L;
        long totalCount = 0L;
        long bufCounter = 0L;
        long deltaT = 0L;
        long counter = 0L;
        Object bufItem = null;
        try {
            long t2;
            long t1 = t2 = System.currentTimeMillis();
            while (true) {
                this.eventToOutputRing1(this.bbSupply1.get());
                this.byteCountTotal += this.writer1.getBytesWrittenToBuffer();
                if (this.socketCount == 2) {
                    this.eventToOutputRing2(this.bbSupply2.get());
                    this.byteCountTotal += this.writer2.getBytesWrittenToBuffer();
                }
                if ((0xFFL & counter++) == 0L) {
                    t2 = System.currentTimeMillis();
                }
                deltaT = t2 - t1;
                if (this.generatingThdId != 0 || deltaT <= (long)printPeriod) continue;
                if (skip-- < 1) {
                    long deltaCount = this.byteCountTotal - oldVal;
                    System.out.println("EmuBlaster: byte rate = " + String.format("%.3g", (double)deltaCount * 1000.0 / (double)deltaT) + ",  avg = " + String.format("%.3g", (double)(totalCount += deltaCount) * 1000.0 / (double)(totalT += deltaT)) + " Hz");
                } else {
                    System.out.println("EmuBlaster: byte rate = " + String.format("%.3g", (double)(this.byteCountTotal - oldVal) * 1000.0 / (double)deltaT) + " Hz");
                }
                t1 = t2;
                oldVal = this.byteCountTotal;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private final void eventToOutputRing1(ByteBufferItem item) throws EvioException, IOException {
        ByteBuffer destBuf = item.getBuffer();
        this.templateBuffer1.position(0);
        int templateSize = this.templateBuffer1.remaining();
        if (destBuf.remaining() < this.templateBuffer1.remaining()) {
            throw new EvioException("specified buffer needs to be bigger (> " + templateSize + ')');
        }
        try {
            if (this.writer1 == null) {
                this.writer1 = new EventWriterUnsync(destBuf);
            } else {
                this.writer1.setBuffer(destBuf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (destBuf.remaining() > templateSize + 64) {
            this.templateBuffer1.position(0);
            this.setTimeStamp(this.templateBuffer1, this.timestamp);
            ++this.timestamp;
            if (this.pCounter1++ < 5) {
                Utilities.printBuffer((ByteBuffer)this.templateBuffer1, (int)0, (int)40, (String)"event 1");
            }
            this.writer1.writeEvent(this.templateBuffer1);
        }
        this.writer1.close();
        this.bbSupply1.publish(item);
    }

    private final void eventToOutputRing2(ByteBufferItem item) throws EvioException, IOException {
        ByteBuffer destBuf = item.getBuffer();
        this.templateBuffer2.position(0);
        int templateSize = this.templateBuffer2.remaining();
        if (destBuf.remaining() < this.templateBuffer2.remaining()) {
            throw new EvioException("specified buffer needs to be bigger (> " + templateSize + ')');
        }
        try {
            if (this.writer2 == null) {
                this.writer2 = new EventWriterUnsync(destBuf);
            } else {
                this.writer2.setBuffer(destBuf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (destBuf.remaining() > templateSize + 64) {
            this.templateBuffer2.position(0);
            this.setTimeStamp(this.templateBuffer2, this.timestamp);
            ++this.timestamp;
            if (this.pCounter2++ < 5) {
                Utilities.printBuffer((ByteBuffer)this.templateBuffer2, (int)0, (int)40, (String)"event 2");
            }
            this.writer2.writeEvent(this.templateBuffer2);
        }
        this.writer2.close();
        this.bbSupply2.publish(item);
    }

    private class SocketSender
    extends Thread {
        private volatile boolean killThd;
        private ByteBufferSupply bbSupply;
        private int position;

        public void killThread() {
            this.killThd = true;
            this.interrupt();
        }

        public SocketSender(ByteBufferSupply bbSupply, int position) {
            this.bbSupply = bbSupply;
            this.position = position;
        }

        @Override
        public void run() {
            boolean i = true;
            System.out.println("Starting SocketSender thread, pos = " + this.position);
            try {
                Socket tcpSocket = new Socket();
                tcpSocket.setTcpNoDelay(EmuBlaster2.this.noDelay);
                tcpSocket.setSendBufferSize(EmuBlaster2.this.sendBufferSize);
                tcpSocket.setPerformancePreferences(0, 0, 1);
                tcpSocket.connect(new InetSocketAddress(EmuBlaster2.this.blasteeHost, EmuBlaster2.this.blasteePort), 2000);
                DataOutputStream domainOut = new DataOutputStream(new BufferedOutputStream(tcpSocket.getOutputStream()));
                domainOut.writeInt(EmuBlaster2.this.id);
                domainOut.writeInt(EmuBlaster2.this.socketCount);
                domainOut.writeInt(this.position);
                while (true) {
                    if (this.killThd) {
                        return;
                    }
                    ByteBufferItem item = this.bbSupply.consumerGet();
                    ByteBuffer buf = item.getBufferAsIs();
                    buf.flip();
                    int binaryLength = buf.remaining();
                    long emuEvioFileFormat = 1L;
                    domainOut.writeLong(emuEvioFileFormat << 32 | (long)binaryLength & 0xFFFFFFFFL);
                    if (binaryLength > 0) {
                        if (EmuBlaster2.this.direct) {
                            domainOut.write(ByteDataTransformer.toByteArray((ByteBuffer)buf));
                        } else {
                            domainOut.write(buf.array(), buf.arrayOffset(), binaryLength);
                        }
                    }
                    domainOut.flush();
                    this.bbSupply.release(item);
                }
            }
            catch (UnsupportedEncodingException tcpSocket) {
            }
            catch (SocketTimeoutException e) {
                System.out.println("EmuBlaster: connection TIMEOUT");
            }
            catch (InterruptedException e) {
                System.out.println("EmuBlaster: socketSender thread interruped");
            }
            catch (IOException e) {
                System.out.println("Blastee is dead");
                System.exit(-1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

