/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.emu.EmuUtilities;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;

public class SenderCmsg {
    private String subject = "ROC1";
    private String subject1 = "ROC1";
    private String subject2 = "ROC2";
    private String type = "data";
    private String name = "ROC1";
    private String channelName = "SingleEmu_SOCKET";
    private String description = "place to send data to EMU";
    private String UDL;
    private int delay = 1000;
    private boolean debug;
    private boolean stopSending;
    private cMsg coda;

    SenderCmsg(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                SenderCmsg.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            SenderCmsg.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java SenderCmsg\n        [-n <name>]          set client name\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of data messages\n        [-t <type>]          set type of data messages\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            SenderCmsg sender = new SenderCmsg(args);
            sender.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running SenderCmsg as EMU's ROC1\n");
        }
        if (this.UDL == null) {
            this.UDL = System.getProperty("cmsgUDL");
        }
        if (this.UDL == null) {
            this.UDL = "cMsg://localhost/cMsg/test";
        }
        System.out.println("Using udl = " + this.UDL);
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.coda.start();
        EmuUtilities.inputStr("Enter to GO");
        this.stopSending = false;
        sendDataThread sender = new sendDataThread();
        sender.start();
        EmuUtilities.inputStr("Enter to QUIT");
        this.stopSending = true;
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class sendDataThread
    extends Thread {
        sendDataThread() {
        }

        @Override
        public void run() {
            System.out.println("Send thread started");
            int rocID = 123;
            int eventID = 10000;
            int dataBankTag = 666;
            int dataBankNum = 777;
            int eventNumber = 1;
            int numEventsInPayloadBank = 1;
            int timestamp = 1000;
            boolean recordId = true;
            boolean numPayloadBanks = true;
            ByteBuffer bbuf = ByteBuffer.allocate(1000);
            cMsgMessage msg = new cMsgMessage();
            msg.setSubject(SenderCmsg.this.subject);
            msg.setType(SenderCmsg.this.type);
            int counter = 0;
            StringWriter sw = new StringWriter(2048);
            PrintWriter wr = new PrintWriter((Writer)sw, true);
            long start_time = System.currentTimeMillis();
            try {
                while (true) {
                    int rocNum = rocID;
                    for (int ix = 0; ix < 2; ++ix) {
                        EventBuilder eventBuilder = new EventBuilder(4660, DataType.BANK, 1);
                        EvioEvent event = eventBuilder.getEvent();
                        EvioBank bank = new EvioBank(34, DataType.UINT32, 0);
                        int[] iarray = new int[]{counter++};
                        eventBuilder.appendIntData((BaseStructure)bank, iarray);
                        eventBuilder.addChild((BaseStructure)event, (BaseStructure)bank);
                        sw.getBuffer().delete(0, sw.getBuffer().capacity());
                        bbuf.clear();
                        event.write(bbuf);
                        bbuf.flip();
                        msg.setByteArrayNoCopy(bbuf.array(), 0, bbuf.limit());
                        msg.setByteArrayEndian(0);
                        if (ix == 0) {
                            msg.setSubject(SenderCmsg.this.subject1);
                            msg.setType("a");
                        } else {
                            msg.setSubject(SenderCmsg.this.subject2);
                            msg.setType("b");
                        }
                        SenderCmsg.this.coda.send(msg);
                        ++rocNum;
                        if (!SenderCmsg.this.stopSending) continue;
                        return;
                    }
                    Thread.sleep(SenderCmsg.this.delay);
                    long now = System.currentTimeMillis();
                    long deltaT = now - start_time;
                    if (deltaT > 2000L) {
                        wr.printf("%d  Hz\n", 3L / deltaT);
                        System.out.println(sw.toString());
                        start_time = now;
                    }
                    ++eventID;
                    timestamp += numEventsInPayloadBank;
                    eventNumber += numEventsInPayloadBank;
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

