/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Random;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.emu.support.codaComponent.CODAClass;

public class RcProtocolTest {
    private int tcpPort;
    private int udpPort;
    private String ipAddress;
    private String name = "DCBCAL";
    private DataOutputStream domainOut;
    private DatagramPacket sendUdpPacket;
    private DatagramSocket udpSocket;
    private Socket tcpSocket;
    private cMsgMessage reportMsg;

    RcProtocolTest(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                RcProtocolTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-tcp")) {
                this.tcpPort = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-udp")) {
                this.udpPort = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-ip")) {
                this.ipAddress = args[i + 1];
                ++i;
                continue;
            }
            RcProtocolTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java RcProtocolTest\n        [-tcp <port>]   TCP port to connect & send msgs to\n        [-udp <port>]   UDP port to connect & send msgs to\n        [-ip  <addr>]   IP address to use\n        [-h]            help\n");
    }

    public static void main(String[] args) {
        try {
            RcProtocolTest receiver = new RcProtocolTest(args);
            receiver.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() {
        try {
            InetAddress rcServerAddress = InetAddress.getByName(this.ipAddress);
            System.out.println("RC protocol test: try making tcp connection to RC test server (host = " + rcServerAddress.getHostName() + ", " + rcServerAddress.getHostAddress() + "; port = " + this.tcpPort + ")");
            this.tcpSocket = new Socket();
            this.tcpSocket.connect(new InetSocketAddress(rcServerAddress, this.tcpPort), 2000);
            this.tcpSocket.setTcpNoDelay(true);
            this.tcpSocket.setSendBufferSize(131072);
            this.domainOut = new DataOutputStream(new BufferedOutputStream(this.tcpSocket.getOutputStream(), 131072));
            System.out.println("RC protocol test: MADE tcp connection to host " + rcServerAddress + ", port " + this.tcpPort);
            this.udpSocket = new DatagramSocket();
            this.udpSocket.setReceiveBufferSize(131072);
            System.out.println("RC protocol test: make udp connection to RC test server");
            this.udpSocket.connect(rcServerAddress, this.udpPort);
            System.out.println("RC protocol test: MADE udp connection to RC test server");
            this.sendUdpPacket = new DatagramPacket(new byte[0], 0, rcServerAddress, this.udpPort);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reportMsg = new cMsgMessage();
        this.reportMsg.setSubject(this.name);
        this.reportMsg.setType("rc/report/status");
        int loop = 1000000;
        try {
            while (loop-- > 0) {
                this.replyToRunControl();
                this.sendStatusMessage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void replyToRunControl() {
        Random randomData = new Random(System.currentTimeMillis());
        String[] states = new String[]{"BOOTED", "CONFIGURED", "DOWNLOADED", "PAUSED", "ACTIVE", "CONFIGURING", "DOWNLOADING", "PRESTARTING", "ACTIVATING", "ENDING"};
        String val = states[randomData.nextInt(10)];
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.setSubject(this.name);
        msg.setType("rc/response/getState");
        msg.setSysMsgId(33);
        msg.setSenderToken(25);
        msg.setGetResponse(true);
        msg.setText(val);
        try {
            this.send((cMsgMessage)msg);
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
    }

    public void send(cMsgMessage message) throws cMsgException {
        if (!message.getReliableSend()) {
            this.udpSend(message);
            return;
        }
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        String payloadTxt = message.getPayloadText();
        int payloadLen = 0;
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int msgType = 21;
        if (message.isGetResponse()) {
            msgType = 20;
        }
        int binaryLength = message.getByteArrayLength();
        try {
            int totalLength = 60 + this.name.length() + subject.length() + type.length() + payloadLen + textLen + binaryLength;
            this.domainOut.writeInt(totalLength);
            this.domainOut.writeInt(msgType);
            this.domainOut.writeInt(6);
            this.domainOut.writeInt(message.getUserInt());
            this.domainOut.writeInt(message.getInfo());
            this.domainOut.writeInt(message.getSenderToken());
            long now = new Date().getTime();
            this.domainOut.writeInt((int)(now >>> 32));
            this.domainOut.writeInt((int)(now & 0xFFFFFFFFL));
            this.domainOut.writeInt((int)(message.getUserTime().getTime() >>> 32));
            this.domainOut.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
            this.domainOut.writeInt(this.name.length());
            this.domainOut.writeInt(subject.length());
            this.domainOut.writeInt(type.length());
            this.domainOut.writeInt(payloadLen);
            this.domainOut.writeInt(textLen);
            this.domainOut.writeInt(binaryLength);
            try {
                this.domainOut.write(this.name.getBytes("US-ASCII"));
                this.domainOut.write(subject.getBytes("US-ASCII"));
                this.domainOut.write(type.getBytes("US-ASCII"));
                if (payloadLen > 0) {
                    this.domainOut.write(payloadTxt.getBytes("US-ASCII"));
                }
                if (textLen > 0) {
                    this.domainOut.write(text.getBytes("US-ASCII"));
                }
                if (binaryLength > 0) {
                    this.domainOut.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.domainOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void udpSend(cMsgMessage message) throws cMsgException {
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        String payloadTxt = message.getPayloadText();
        int payloadLen = 0;
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int msgType = 21;
        if (message.isGetResponse()) {
            msgType = 20;
        }
        int binaryLength = message.getByteArrayLength();
        int totalLength = 60 + this.name.length() + subject.length() + type.length() + payloadLen + textLen + binaryLength;
        if (totalLength > 8192) {
            throw new cMsgException("Too big a message for UDP to send");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        DataOutputStream out = new DataOutputStream(baos);
        try {
            out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
            out.writeInt(totalLength);
            out.writeInt(msgType);
            out.writeInt(6);
            out.writeInt(message.getUserInt());
            out.writeInt(message.getInfo());
            out.writeInt(message.getSenderToken());
            long now = new Date().getTime();
            out.writeInt((int)(now >>> 32));
            out.writeInt((int)(now & 0xFFFFFFFFL));
            out.writeInt((int)(message.getUserTime().getTime() >>> 32));
            out.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
            out.writeInt(this.name.length());
            out.writeInt(subject.length());
            out.writeInt(type.length());
            out.writeInt(payloadLen);
            out.writeInt(textLen);
            out.writeInt(binaryLength);
            try {
                out.write(this.name.getBytes("US-ASCII"));
                out.write(subject.getBytes("US-ASCII"));
                out.write(type.getBytes("US-ASCII"));
                if (payloadLen > 0) {
                    out.write(payloadTxt.getBytes("US-ASCII"));
                }
                if (textLen > 0) {
                    out.write(text.getBytes("US-ASCII"));
                }
                if (binaryLength > 0) {
                    out.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            out.flush();
            out.close();
            byte[] buf = baos.toByteArray();
            this.sendUdpPacket.setData(buf, 0, buf.length);
            this.udpSocket.send(this.sendUdpPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void sendStatusMessage() {
        Random randomData = new Random(System.currentTimeMillis());
        long eventCount = randomData.nextLong();
        long wordCount = randomData.nextLong();
        float eventRate = randomData.nextFloat();
        float dataRate = randomData.nextFloat();
        int maxEvSize = randomData.nextInt(3000000);
        int minEvSize = randomData.nextInt(10000);
        int avgEvSize = randomData.nextInt(1000000);
        int chunk_X_EtBuf = randomData.nextInt(15000000);
        int[] timeToBuild = null;
        int[] inChanLevels = new int[]{randomData.nextInt(100), randomData.nextInt(100), randomData.nextInt(100), randomData.nextInt(100), randomData.nextInt(100), randomData.nextInt(100), randomData.nextInt(100), randomData.nextInt(100)};
        int[] outChanLevels = new int[]{randomData.nextInt(100), randomData.nextInt(100)};
        String[] inChanNames = new String[]{"ROC10", "ROC11", "ROC12", "ROC13", "ROC14", "ROC15", "ROC16", "ROC17"};
        String[] outChanNames = new String[]{"SEB1, SEB2"};
        String[] states = new String[]{"BOOTED", "CONFIGURED", "DOWNLOADED", "PAUSED", "ACTIVE", "CONFIGURING", "DOWNLOADING", "PRESTARTING", "ACTIVATING", "ENDING"};
        String state = states[randomData.nextInt(10)];
        try {
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("state", state.toLowerCase()));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("codaClass", CODAClass.DC.name()));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("objectType", "coda3"));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("eventCount", (int)eventCount));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("eventCount64", eventCount));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("dataCount", wordCount));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("eventRate", eventRate));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("dataRate", (double)dataRate));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("maxEventSize", maxEvSize));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("minEventSize", minEvSize));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("avgEventSize", avgEvSize));
            this.reportMsg.addPayloadItem(new cMsgPayloadItem("chunk_X_EtBuf", chunk_X_EtBuf));
            if (inChanLevels != null && inChanLevels.length > 0) {
                this.reportMsg.addPayloadItem(new cMsgPayloadItem("inputChanLevels", inChanLevels));
                this.reportMsg.addPayloadItem(new cMsgPayloadItem("inputChanNames", inChanNames));
            } else {
                this.reportMsg.removePayloadItem("inputChanLevels");
                this.reportMsg.removePayloadItem("inputChanNames");
            }
            if (outChanLevels != null && outChanLevels.length > 0) {
                this.reportMsg.addPayloadItem(new cMsgPayloadItem("outputChanLevels", outChanLevels));
                this.reportMsg.addPayloadItem(new cMsgPayloadItem("outputChanNames", outChanNames));
            } else {
                this.reportMsg.removePayloadItem("outputChanLevels");
                this.reportMsg.removePayloadItem("outputChanNames");
            }
            if (timeToBuild != null && timeToBuild.length > 0) {
                this.reportMsg.addPayloadItem(new cMsgPayloadItem("timeToBuild", timeToBuild));
            } else {
                this.reportMsg.removePayloadItem("timeToBuild");
            }
            this.send(this.reportMsg);
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
    }
}

