/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.test;

import java.util.concurrent.CountDownLatch;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.emu.support.transport.DataTransportImplEmu;
import org.jlab.coda.emu.test.LocalEmuDomainTcpServer;
import org.jlab.coda.emu.test.LocalEmuDomainUdpListener;

class LocalEmuDomainServer
extends Thread {
    String domain = "emu";
    final int serverPort;
    int localTempPort;
    CountDownLatch multicastResponse = new CountDownLatch(1);
    String respondingHost;
    volatile boolean acceptingClients;
    private LocalEmuDomainUdpListener listener;
    private LocalEmuDomainTcpServer tcpServer;
    private final String expid;
    private final String name;
    final DataTransportImplEmu transport;

    public LocalEmuDomainServer(int port, String expid, String name, DataTransportImplEmu transport) throws cMsgException {
        this.name = name;
        this.expid = expid;
        this.serverPort = port;
        this.transport = transport;
    }

    public LocalEmuDomainTcpServer getTcpServer() {
        return this.tcpServer;
    }

    public void stopServer() {
        this.listener.killAllThreads();
        this.tcpServer.killAllThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.tcpServer = new LocalEmuDomainTcpServer(this, this.serverPort);
            this.tcpServer.start();
            Thread thread = this.tcpServer;
            synchronized (thread) {
                if (!this.tcpServer.isAlive()) {
                    try {
                        this.tcpServer.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.listener = new LocalEmuDomainUdpListener(this, this.serverPort, this.expid, this.name);
            this.listener.start();
            thread = this.listener;
            synchronized (thread) {
                if (!this.listener.isAlive()) {
                    try {
                        this.listener.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
    }
}

