/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.ui.log;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.logger.LoggerAppender;
import org.jlab.coda.emu.support.logger.LoggingEvent;
import org.jlab.coda.emu.support.logger.QueueAppender;
import org.jlab.coda.emu.support.ui.log.LogTextCaret;

public class SwingLogConsoleDialog
extends JTextPane
implements LoggerAppender {
    private static final long serialVersionUID = 1L;
    private LogTextCaret caret = new LogTextCaret();
    private Logger logger;
    QueueAppender logQueueAppender;
    Thread monitorThread;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public SwingLogConsoleDialog() {
        this.setCaret(this.caret);
        this.setEditable(false);
        Style style = this.addStyle("Red", null);
        StyleConstants.setForeground(style, Color.red);
        style = this.addStyle("WARN", null);
        StyleConstants.setForeground(style, new Color(200, 155, 0));
        style = this.addStyle("INFO", null);
        StyleConstants.setForeground(style, new Color(0, 150, 0));
        style = this.addStyle("Gray", null);
        StyleConstants.setForeground(style, Color.gray);
        style = this.addStyle("DEBUG", null);
        StyleConstants.setForeground(style, Color.blue);
        style = this.addStyle("ERROR", null);
        StyleConstants.setBold(style, true);
        StyleConstants.setForeground(style, Color.red);
        style = this.addStyle("pt18", null);
        StyleConstants.setFontSize(style, 18);
    }

    public void monitor(QueueAppender appender) {
        this.logQueueAppender = appender;
        this.monitorThread = new Thread(new MonitorRunnable());
        this.monitorThread.start();
    }

    public void close() {
        this.monitorThread.interrupt();
        this.logger.removeAppender(this.logQueueAppender);
    }

    public void clear() {
        Document d = this.getDocument();
        try {
            d.remove(0, d.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void append(LoggingEvent event) {
        Document d = this.getDocument();
        try {
            d.insertString(d.getLength(), SwingLogConsoleDialog.formatEventTime(event.getEventTime()), this.getStyle("Gray"));
            switch (event.getLevel()) {
                case 11: {
                    d.insertString(d.getLength(), "  ERROR \t", this.getStyle("ERROR"));
                    break;
                }
                case 2: {
                    d.insertString(d.getLength(), "  INFO \t", this.getStyle("INFO"));
                    break;
                }
                case 1: {
                    d.insertString(d.getLength(), "  DEBUG \t", this.getStyle("DEBUG"));
                    break;
                }
                case 8: {
                    d.insertString(d.getLength(), "  WARN \t", this.getStyle("WARN"));
                }
            }
            d.insertString(d.getLength(), event.getMessage(), null);
            d.insertString(d.getLength(), "\n", this.getStyle("Gray"));
            JViewport viewport = (JViewport)this.getParent();
            boolean scrollToBottom = Math.abs(viewport.getViewPosition().getY() - (double)(this.getHeight() - viewport.getHeight())) < 100.0;
            this.caret.setVisibilityAdjustment(scrollToBottom);
            if (scrollToBottom) {
                this.setCaretPosition(this.getText().length());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private static String formatEventTime(long eventTime) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
        return format.format(new Date(eventTime));
    }

    public void append(String str) {
        Document d = this.getDocument();
        try {
            d.insertString(d.getLength(), str, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void append(String str, String style) {
        StyledDocument d = this.getStyledDocument();
        try {
            int start = d.getLength();
            d.insertString(d.getLength(), str, null);
            d.setCharacterAttributes(start, str.length(), this.getStyle(style), true);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected class MonitorRunnable
    implements Runnable {
        protected MonitorRunnable() {
        }

        @Override
        public void run() {
            while (!SwingLogConsoleDialog.this.monitorThread.isInterrupted()) {
                LoggingEvent event = SwingLogConsoleDialog.this.logQueueAppender.poll(1);
                if (event == null) continue;
                SwingLogConsoleDialog.this.append(event);
            }
        }
    }
}

