/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.emu.support.codaComponent.CODACommand;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.codaComponent.CODATransition;
import org.jlab.coda.emu.support.control.Command;
import org.jlab.coda.emu.support.control.CommandAcceptor;

public class SmartToolbar
extends JToolBar {
    private static final long serialVersionUID = 7241838854981192095L;
    private final HashMap<String, Command> buttonHandlers = new HashMap(8);
    private final HashMap<String, JTextField> textFields = new HashMap(8);

    public SmartToolbar() {
        this.setFloatable(true);
    }

    public SmartToolbar(int orientation) {
        super(orientation);
    }

    public SmartToolbar(String name) {
        super(name);
    }

    public SmartToolbar(String name, int orientation) {
        super(name, orientation);
    }

    public void updateButtons(CODAStateIF state) {
        Component[] comps;
        EnumSet<CODATransition> eSet = state.allowed();
        int i = 0;
        String[] names = new String[eSet.size()];
        for (CODATransition tran : eSet) {
            names[i++] = tran.name();
        }
        block1: for (Component comp : comps = this.getComponents()) {
            JButton button = (JButton)comp;
            button.setEnabled(false);
            for (String name : names) {
                if (!button.getName().equals(name)) continue;
                button.setEnabled(true);
                continue block1;
            }
        }
    }

    public void configure(CommandAcceptor target, int guiGroup) {
        EnumSet<CODACommand> emuCmdSet = CODACommand.getGuiGroup(guiGroup);
        try {
            for (CODACommand codaCmd : emuCmdSet) {
                Command cmd = new Command(codaCmd);
                cmd.fromDebugGui(true);
                String name = cmd.name();
                this.buttonHandlers.put(name, cmd);
                JButton tbb = new JButton(name);
                tbb.setActionCommand(name);
                this.addButtonListener(target, tbb);
                tbb.setName(name);
                this.add(tbb);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void addButtonListener(final CommandAcceptor target, JButton tbb) {
        ActionListener[] listeners;
        for (ActionListener l : listeners = tbb.getActionListeners()) {
            tbb.removeActionListener(l);
        }
        tbb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Command cmd = (Command)SmartToolbar.this.buttonHandlers.get(e.getActionCommand());
                try {
                    target.postCommand(cmd);
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        });
    }

    void addButtonListener(final CommandAcceptor target, JButton tbb, final JTextField textField) {
        ActionListener[] listeners;
        for (ActionListener l : listeners = tbb.getActionListeners()) {
            tbb.removeActionListener(l);
        }
        tbb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Command cmd = (Command)SmartToolbar.this.buttonHandlers.get(e.getActionCommand());
                CODACommand codaCommand = cmd.getCodaCommand();
                CODACommand.InputType type = codaCommand.getInputType();
                String txt = textField.getText();
                System.out.println("READ TXT AS -> " + txt);
                if (txt == null || txt.isEmpty()) {
                    cmd.setMessage(null);
                } else {
                    cMsgMessage msg = new cMsgMessage();
                    switch (type) {
                        case TEXT: {
                            msg.setText(txt);
                            break;
                        }
                        case USER_INT: {
                            try {
                                int i = Integer.parseInt(txt);
                                msg.setUserInt(i);
                                break;
                            }
                            catch (NumberFormatException ex) {
                                JOptionPane.showMessageDialog(SmartToolbar.this, "Not integer in textfield", "Error", 0);
                                return;
                            }
                        }
                        case PAYLOAD_INT: {
                            String payloadName;
                            try {
                                int i = Integer.parseInt(txt);
                                payloadName = codaCommand.getPayloadName();
                                System.out.println("Creating payload int with name = " + payloadName);
                                cMsgPayloadItem item = new cMsgPayloadItem(payloadName, i);
                                cmd.setArg(payloadName, item);
                                msg.addPayloadItem(item);
                                break;
                            }
                            catch (NumberFormatException ex) {
                                JOptionPane.showMessageDialog(SmartToolbar.this, "Not integer in textfield", "Error", 0);
                                return;
                            }
                            catch (cMsgException cMsgException2) {
                                break;
                            }
                        }
                        case PAYLOAD_TEXT: {
                            String payloadName;
                            try {
                                payloadName = codaCommand.getPayloadName();
                                cMsgPayloadItem item = new cMsgPayloadItem(payloadName, txt);
                                cmd.setArg(payloadName, item);
                                msg.addPayloadItem(item);
                            }
                            catch (cMsgException cMsgException3) {}
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    cmd.setMessage(msg);
                }
                try {
                    target.postCommand(cmd);
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        });
    }

    public void reset() {
        this.removeAll();
    }
}

