/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.DataChannelImplEt;
import org.jlab.coda.emu.support.transport.DataTransportAdapter;
import org.jlab.coda.emu.support.transport.DataTransportException;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.exception.EtClosedException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemCreate;

public class DataTransportImplEt
extends DataTransportAdapter {
    private boolean tryToCreateET;
    private boolean createdET;
    private boolean isJavaSystem;
    private EtSystem etSystem;
    private EtSystemOpenConfig openConfig;
    private SystemConfig systemConfig;
    private SystemCreate etSysLocal;
    private Process processET;
    private Emu emu;
    private Logger logger;
    private ControlCThread shutdownThread = new ControlCThread();

    private static String getProcessOutput(InputStream inputStream) {
        StringBuilder sb = new StringBuilder(300);
        BufferedReader brErr = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = brErr.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    private static String[] gatherAllOutput(Process process, boolean monitor) {
        String output;
        String[] strs = new String[2];
        if (monitor && (output = DataTransportImplEt.getProcessOutput(process.getInputStream())) != null) {
            strs[0] = output;
        }
        if ((output = DataTransportImplEt.getProcessOutput(process.getErrorStream())) != null) {
            strs[1] = output;
        }
        return strs;
    }

    public DataTransportImplEt(String pname, Map<String, String> attrib, Emu emu) throws DataNotFoundException {
        super(pname, attrib, emu);
        this.emu = emu;
        this.logger = emu.getLogger();
        String etName = attrib.get("etName");
        if (etName == null) {
            etName = "/tmp/" + emu.getExpid() + '_' + emu.name();
        }
        int port = 11111;
        String str = attrib.get("port");
        if (str != null) {
            try {
                port = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int uport = 11111;
        str = attrib.get("uPort");
        if (str != null) {
            try {
                uport = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        List<String> mAddrList = null;
        String maddr = attrib.get("mAddr");
        if (maddr != null) {
            String[] mAddrs = new String[]{maddr};
            mAddrList = Arrays.asList(mAddrs);
        }
        int wait = 0;
        str = attrib.get("wait");
        if (str != null) {
            try {
                wait = 1000 * Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.tryToCreateET = false;
        str = attrib.get("create");
        if (str != null && (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("on") || str.equalsIgnoreCase("yes"))) {
            this.tryToCreateET = true;
        }
        String preferredSubnet = null;
        int method = 2;
        List<String> bAddrList = null;
        String host = ".local";
        if (this.tryToCreateET) {
            this.systemConfig = new SystemConfig();
            this.isJavaSystem = false;
            str = attrib.get("type");
            if (str != null && str.equalsIgnoreCase("java")) {
                this.isJavaSystem = true;
            }
            if (this.isJavaSystem) {
                System.out.println("    DataTransport Et: create Java ET in this JVM, but not yet");
            }
            int eventNum = 0;
            str = attrib.get("eventNum");
            if (str != null) {
                try {
                    eventNum = Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int eventSize = 0;
            str = attrib.get("eventSize");
            if (str != null) {
                try {
                    eventSize = Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int tcpSendBuf = 0;
            str = attrib.get("sendBuf");
            if (str != null) {
                try {
                    tcpSendBuf = Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int tcpRecvBuf = 0;
            str = attrib.get("recvBuf");
            if (str != null) {
                try {
                    tcpRecvBuf = Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean noDelay = false;
            str = attrib.get("noDelay");
            if (str != null && (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("on") || str.equalsIgnoreCase("yes"))) {
                noDelay = true;
            }
            int groups = 1;
            str = attrib.get("groups");
            if (str != null) {
                try {
                    groups = Integer.parseInt(str);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                this.systemConfig.setNumEvents(eventNum);
                this.systemConfig.setEventSize(eventSize);
                this.systemConfig.setServerPort(port);
                this.systemConfig.setUdpPort(uport);
                this.systemConfig.setTcpSendBufSize(tcpSendBuf);
                this.systemConfig.setTcpRecvBufSize(tcpRecvBuf);
                this.systemConfig.setNoDelay(noDelay);
                if (maddr != null) {
                    this.systemConfig.addMulticastAddr(maddr);
                }
                if (groups > 1) {
                    int[] g = new int[groups];
                    for (int i = 0; i < eventNum; ++i) {
                        int n = i % groups;
                        g[n] = g[n] + 1;
                    }
                    this.systemConfig.setGroups(g);
                }
            }
            catch (EtException e) {
                this.transportState = CODAState.ERROR;
                emu.setErrorState("Transport et: incomplete specification of ET system, " + e.getMessage());
                throw new DataNotFoundException("incomplete specification of ET system", e);
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        } else {
            str = attrib.get("method");
            if (str == null) {
                method = 1;
            } else if (str.equalsIgnoreCase("cast")) {
                method = 3;
            } else if (str.equalsIgnoreCase("bcast")) {
                method = 1;
            } else if (str.equalsIgnoreCase("mcast")) {
                method = 0;
            } else if (str.equalsIgnoreCase("direct")) {
                method = 2;
            }
            host = attrib.get("host");
            if (host == null) {
                host = ".anywhere";
            } else if (host.equalsIgnoreCase("local")) {
                host = ".local";
            } else if (host.equalsIgnoreCase("anywhere")) {
                host = ".anywhere";
            } else if (host.equalsIgnoreCase("remote")) {
                host = ".remote";
            }
            preferredSubnet = attrib.get("subnet");
            String baddr = attrib.get("bAddr");
            if (baddr != null) {
                String[] bAddrs = new String[]{baddr};
                bAddrList = Arrays.asList(bAddrs);
            }
        }
        try {
            this.openConfig = new EtSystemOpenConfig(etName, host, bAddrList, mAddrList, false, method, port, uport, 32, 2);
            if (preferredSubnet != null) {
                try {
                    this.openConfig.setNetworkInterface(preferredSubnet);
                    System.out.println("    DataTransport Et: preferred subnet set to " + preferredSubnet);
                }
                catch (EtException e) {
                    System.out.println("    DataTransport Et: ignoring preferred subnet of " + preferredSubnet);
                }
            }
            this.openConfig.setWaitTime((long)wait);
        }
        catch (EtException e) {
            this.transportState = CODAState.ERROR;
            emu.setErrorState("Transport et: bad station parameters in config file, " + e.getMessage());
            throw new DataNotFoundException("Bad station parameters in config file", e);
        }
    }

    public boolean tryToCreateET() {
        return this.tryToCreateET;
    }

    public EtSystemOpenConfig getOpenConfig() {
        return this.openConfig;
    }

    public SystemConfig getSystemConfig() {
        return this.systemConfig;
    }

    public SystemCreate getLocalEtSystem() {
        return this.etSysLocal;
    }

    public int getEventsInGroup() {
        if (this.systemConfig == null) {
            return 0;
        }
        return this.systemConfig.getNumEvents() / this.systemConfig.getGroups().length;
    }

    @Override
    public DataChannel createChannel(String name, Map<String, String> attributeMap, boolean isInput, Emu emu, EmuModule module, int outputIndex) throws DataTransportException {
        return new DataChannelImplEt(name, this, attributeMap, isInput, emu, module, outputIndex);
    }

    @Override
    public void reset() {
        this.setConnected(false);
        if (this.createdET) {
            try {
                this.killEtSystem();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean killEtSystem() {
        this.logger.info("    DataTransport Et: tell ET to die - " + this.openConfig.getEtName());
        boolean killedIt = false;
        if (this.etSysLocal != null) {
            this.logger.info("    DataTransport Et: shutdown local Java ET system");
            this.etSysLocal.shutdown();
        } else {
            this.logger.info("    DataTransport Et: try killing local C ET system");
            if (this.etSystem != null) {
                try {
                    this.etSystem.kill();
                    this.logger.info("    DataTransport Et: told ET directly to die");
                    return true;
                }
                catch (IOException iOException) {
                }
                catch (EtClosedException etClosedException) {
                    // empty catch block
                }
            }
            if (this.processET != null) {
                this.processET.destroy();
                try {
                    this.processET.waitFor();
                    this.logger.info("    DataTransport Et: used java process handle to kill ET");
                    killedIt = true;
                    this.processET = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        File etFile = new File(this.openConfig.getEtName());
        etFile.delete();
        return killedIt;
    }

    @Override
    public void download() throws CmdExecException {
        EtSystemOpenConfig etOpenConfig;
        if (!this.tryToCreateET) {
            return;
        }
        this.createdET = false;
        try {
            ArrayList<String> mAddrs = new ArrayList<String>(6);
            mAddrs.add("239.200.0.0");
            etOpenConfig = new EtSystemOpenConfig(this.openConfig.getEtName(), ".anywhere", mAddrs, this.openConfig.getUdpPort(), 32);
            etOpenConfig.setWaitTime(2000L);
            etOpenConfig.setConnectRemotely(true);
            this.etSystem = new EtSystem(etOpenConfig);
        }
        catch (EtException e) {
            this.transportState = CODAState.ERROR;
            this.emu.setErrorState("Transport et: self-contradictory ET system config");
            System.out.println("    DataTransport Et: self-contradictory ET system config : " + this.name());
            throw new CmdExecException("Self-contradictory ET system config", e);
        }
        try {
            while (true) {
                this.etSystem.open();
                this.logger.info("    DataTransport Et: opened existing ET system, " + this.name() + " on " + this.etSystem.getHost() + ", try to kill it ...");
                this.killEtSystem();
            }
        }
        catch (Exception e) {
            block25: {
                this.etSystem = null;
                try {
                    if (this.isJavaSystem) {
                        this.logger.debug("    DataTransport Et: create local Java ET system, " + etOpenConfig.getEtName());
                        this.etSysLocal = new SystemCreate(this.openConfig.getEtName(), this.systemConfig);
                        break block25;
                    }
                    etOpenConfig = new EtSystemOpenConfig(this.openConfig);
                    etOpenConfig.setWaitTime(30000L);
                    etOpenConfig.setConnectRemotely(true);
                    String etCmd = "et_start -v -f " + etOpenConfig.getEtName() + " -s " + this.systemConfig.getEventSize() + " -n " + this.systemConfig.getNumEvents() + " -g " + this.systemConfig.getGroups().length + " -p " + this.systemConfig.getServerPort() + " -u " + this.systemConfig.getUdpPort() + " -d";
                    if (this.systemConfig.getMulticastAddrs().size() > 0) {
                        etCmd = etCmd + " -a " + this.systemConfig.getMulticastStrings()[0];
                    }
                    if (this.systemConfig.getTcpRecvBufSize() > 0) {
                        etCmd = etCmd + " -rb " + this.systemConfig.getTcpRecvBufSize();
                    }
                    if (this.systemConfig.getTcpSendBufSize() > 0) {
                        etCmd = etCmd + " -sb " + this.systemConfig.getTcpSendBufSize();
                    }
                    if (this.systemConfig.isNoDelay()) {
                        etCmd = etCmd + " -nd";
                    }
                    this.logger.debug("    DataTransport Et: create local C ET system, " + etOpenConfig.getEtName() + " with cmd:\n" + etCmd);
                    String[] cmd = etCmd.split(" ");
                    ProcessBuilder pb = new ProcessBuilder(cmd).inheritIO();
                    this.processET = pb.start();
                    Thread.yield();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    boolean terminated = true;
                    try {
                        this.processET.exitValue();
                    }
                    catch (IllegalThreadStateException e2) {
                        terminated = false;
                    }
                    if (terminated) {
                        this.logger.debug("    DataTransport Et:  ET system process was terminated");
                        String errorOut = "";
                        String[] retStrings = DataTransportImplEt.gatherAllOutput(this.processET, true);
                        if (retStrings[0] != null) {
                            errorOut = errorOut + retStrings[0];
                        }
                        if (retStrings[1] != null) {
                            if (retStrings[0] != null) {
                                errorOut = errorOut + "\n";
                            }
                            errorOut = errorOut + retStrings[1];
                        }
                        try {
                            ServerSocket socketserv = new ServerSocket(this.systemConfig.getServerPort());
                            this.transportState = CODAState.ERROR;
                            this.emu.setErrorState("Transport et: " + errorOut);
                            this.logger.debug(errorOut);
                            throw new CmdExecException(errorOut);
                        }
                        catch (IOException ex) {
                            this.transportState = CODAState.ERROR;
                            this.emu.setErrorState("cannot run ET system, port " + this.systemConfig.getServerPort() + " already in use");
                            this.logger.debug("cannot run ET system, port " + this.systemConfig.getServerPort() + " already in use");
                            throw new CmdExecException(errorOut);
                        }
                    }
                    try {
                        this.etSystem = new EtSystem(etOpenConfig);
                        this.etSystem.setDebug(4);
                        this.etSystem.open();
                    }
                    catch (Exception e3) {
                        this.etSystem = null;
                        this.transportState = CODAState.ERROR;
                        this.emu.setErrorState("Transport et: created ET system " + etOpenConfig.getEtName() + ", but cannot connect");
                        throw new CmdExecException("created ET, " + etOpenConfig.getEtName() + ", but cannot connect", e3);
                    }
                    this.shutdownThread.reset(this.etSystem, etOpenConfig.getEtName());
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                    this.etSystem = null;
                    this.transportState = CODAState.ERROR;
                    this.emu.setErrorState("Transport et: cannot run ET system, " + e4.getMessage());
                    throw new CmdExecException("cannot run ET system", e4);
                }
            }
            this.createdET = true;
            return;
        }
    }

    private static class ControlCThread
    extends Thread {
        EtSystem etSys;
        String etFileName;

        ControlCThread() {
        }

        ControlCThread(EtSystem etSys, String etFileName) {
            this.etSys = etSys;
            this.etFileName = etFileName;
        }

        void reset(EtSystem etSys, String etFileName) {
            this.etSys = etSys;
            this.etFileName = etFileName;
        }

        @Override
        public void run() {
            if (this.etSys != null && this.etSys.alive()) {
                try {
                    this.etSys.kill();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.etFileName != null) {
                try {
                    File etFile = new File(this.etFileName);
                    if (etFile.exists() && etFile.isFile()) {
                        etFile.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

