/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.util.HashMap;
import java.util.Map;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.DataChannelImplEmu;
import org.jlab.coda.emu.support.transport.DataTransportAdapter;
import org.jlab.coda.emu.support.transport.DataTransportException;
import org.jlab.coda.emu.support.transport.EmuDomainServer;

public class DataTransportImplEmu
extends DataTransportAdapter {
    private final Logger logger;
    private int port;
    private EmuDomainServer emuServer;
    final HashMap<Integer, DataChannelImplEmu> inputChannelTable = new HashMap(16);

    public DataTransportImplEmu(String pname, Map<String, String> attrib, Emu emu) throws DataNotFoundException, cMsgException {
        super(pname, attrib, emu);
        this.logger = emu.getLogger();
        if (!this.isServer) {
            block5: {
                String portStr = attrib.get("port");
                if (portStr != null) {
                    try {
                        this.port = Integer.parseInt(portStr);
                        if (this.port < 1024 || this.port > 65535) {
                            this.transportState = CODAState.ERROR;
                            emu.setErrorState("Transport Emu: bad port value (" + this.port + ')');
                            throw new DataNotFoundException("Bad port value (" + this.port + ')');
                        }
                        break block5;
                    }
                    catch (NumberFormatException e) {
                        this.transportState = CODAState.ERROR;
                        emu.setErrorState("Transport Emu: bad port value (" + portStr + ')');
                        throw new DataNotFoundException("Bad port value (" + portStr + ')');
                    }
                }
                this.port = 46100;
                this.logger.debug("    Transport Emu: port should be specified in config file, using default " + this.port);
            }
            this.logger.debug("    Transport Emu: start up emu server in " + emu.name() + " @ port " + this.port);
            this.emuServer = new EmuDomainServer(this.port, emu.getExpid(), emu.name(), this);
            this.emuServer.start();
        }
    }

    @Override
    public DataChannel createChannel(String name, Map<String, String> attributeMap, boolean isInput, Emu emu, EmuModule module, int outputIndex) throws DataTransportException {
        DataChannelImplEmu newChannel = new DataChannelImplEmu(name, this, attributeMap, isInput, emu, module, outputIndex);
        if (isInput) {
            this.inputChannelTable.put(newChannel.getID(), newChannel);
        }
        return newChannel;
    }

    @Override
    public void reset() {
        this.inputChannelTable.clear();
        try {
            if (this.emuServer != null) {
                this.logger.debug("    Transport Emu reset: stop emu server : " + this.name());
                this.emuServer.stopServer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

