/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.transport;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.codaComponent.CODAStateMachineAdapter;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.transport.DataTransport;

public abstract class DataTransportAdapter
extends CODAStateMachineAdapter
implements DataTransport {
    protected String name;
    protected CODAStateIF transportState;
    protected AtomicReference<String> errorMsg = new AtomicReference();
    protected Emu emu;
    protected Logger logger;
    protected boolean isServer;
    protected boolean connected;
    protected String transportClass = "unknown";
    protected final Map<String, String> attr;

    public DataTransportAdapter(String name, Map<String, String> attrib, Emu emu) throws DataNotFoundException {
        this.name = name;
        this.attr = attrib;
        this.emu = emu;
        if (emu != null) {
            this.logger = emu.getLogger();
        }
        this.transportClass = this.getAttr("class");
        String serverS = this.getAttr("server");
        this.isServer = Boolean.valueOf(serverS);
    }

    @Override
    public String getTransportClass() {
        return this.transportClass;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CODAStateIF state() {
        return this.transportState;
    }

    @Override
    public String getError() {
        return this.errorMsg.get();
    }

    @Override
    public void setAttr(String name, String value) {
        this.attr.put(name, value);
    }

    @Override
    public String getAttr(String name) throws DataNotFoundException {
        String attribute = this.attr.get(name);
        if (attribute == null) {
            throw new DataNotFoundException("attribute " + name + " not found in config for " + this.name());
        }
        return attribute;
    }

    @Override
    public int getIntAttr(String name) throws DataNotFoundException {
        return Integer.parseInt(this.getAttr(name));
    }

    @Override
    public boolean isServer() {
        return this.isServer;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public void reset() {
        this.connected = false;
    }
}

