/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.support.logger;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jlab.coda.emu.support.logger.LoggerAppender;
import org.jlab.coda.emu.support.logger.LoggingEvent;

public class QueueAppender
implements LoggerAppender {
    private final ArrayBlockingQueue<LoggingEvent> queue;

    public QueueAppender(int bufferSize) {
        this.queue = new ArrayBlockingQueue(bufferSize);
    }

    @Override
    public void append(LoggingEvent event) {
        this.queue.add(event);
        if (this.queue.size() > 1000) {
            try {
                this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public LoggingEvent poll() {
        return this.queue.poll();
    }

    public LoggingEvent poll(int wait) {
        try {
            return this.queue.poll(wait, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }
}

