/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import java.util.ArrayList;
import java.util.Map;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.control.CmdExecException;

public class TsSimulation
extends ModuleAdapter {
    private String subjectIn = "syncFromRoc";
    private cMsgSubscriptionHandle sub;
    private cMsgMessage message;
    private cMsg coda;
    private int count;
    private boolean debug = true;
    private ArrayList<String> expectedRocs = new ArrayList(10);
    private ArrayList<String> respondingRocs = new ArrayList(10);
    private ArrayList<Integer> respondingStates = new ArrayList(10);
    private myCallback callback = new myCallback();

    public TsSimulation(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
        String roc;
        int rocCount = 2;
        String rocName = "r1";
        while ((roc = attributeMap.get(rocName)) != null) {
            System.out.println("  TS mod: adding roc " + rocName);
            this.expectedRocs.add(rocName);
            rocName = "r" + rocCount++;
        }
        this.message = new cMsgMessage();
        this.message.setSubject("sync");
        this.message.setType("ROC");
        try {
            this.message.setHistoryLengthMax(0);
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
    }

    @Override
    public void go() {
        this.moduleState = CODAState.ACTIVE;
        this.paused = false;
    }

    @Override
    public void prestart() {
        if (this.debug) {
            System.out.println("  TS: prestart");
        }
        this.coda = this.emu.getCmsgPortal().getCmsgServer();
        try {
            if (this.sub != null) {
                this.coda.unsubscribe(this.sub);
            }
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        try {
            this.sub = this.coda.subscribe(this.subjectIn, "*", (cMsgCallbackInterface)this.callback, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.moduleState = CODAState.PAUSED;
        this.paused = false;
    }

    @Override
    public void reset() {
        if (this.debug) {
            System.out.println("  TS mod: reset()");
        }
        try {
            if (this.coda != null && this.sub != null) {
                this.coda.unsubscribe(this.sub);
            }
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        this.moduleState = CODAState.CONFIGURED;
        this.paused = false;
    }

    @Override
    public void end() throws CmdExecException {
        if (this.debug) {
            System.out.println("  TS mod: end()");
        }
        this.moduleState = CODAState.DOWNLOADED;
        this.paused = false;
    }

    private class myCallback
    extends cMsgCallbackAdapter {
        private myCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            TsSimulation.this.respondingRocs.add(msg.getType());
            TsSimulation.this.respondingStates.add(msg.getUserInt());
            if (TsSimulation.this.respondingRocs.size() == TsSimulation.this.expectedRocs.size()) {
                if (!TsSimulation.this.respondingStates.contains(0)) {
                    System.out.println("  TS mod: all ROCs got end cmd");
                    TsSimulation.this.message.setUserInt(1);
                } else {
                    TsSimulation.this.message.setUserInt(0);
                }
                try {
                    TsSimulation.this.coda.send(TsSimulation.this.message);
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
                TsSimulation.this.respondingRocs.clear();
                TsSimulation.this.respondingStates.clear();
                TsSimulation.this.count++;
            }
        }
    }
}

