/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.RingBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Phaser;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAClass;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.ByteBufferItem;
import org.jlab.coda.emu.support.data.ByteBufferSupply;
import org.jlab.coda.emu.support.data.CODATag;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.EventType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.PayloadBuffer;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;

public class RocSimulation
extends ModuleAdapter {
    private volatile int rocRecordId;
    private EventGeneratingThread[] eventGeneratingThreads;
    private int triggerType;
    private int eventBlockSize;
    private int detectorId;
    private int eventWordSize;
    private int eventSize;
    private int syncCount;
    private int loops;
    private int bufSupplySize = 4096;
    private boolean noPhysics;
    private boolean synced;
    private int syncBitCount;
    private cMsg cMsgServer;
    private cMsgMessage message;
    private cMsgSubscriptionHandle cmsgSubHandle;
    private Phaser phaser;
    private Phaser endPhaser;
    private volatile boolean timeToEnd;
    private volatile boolean gotEndCommand;
    private volatile boolean gotResetCommand;
    private volatile boolean gotGoCommand;
    private SyncCallback callback = new SyncCallback();

    private static PayloadBuffer createUserBuffer(ByteOrder order, boolean isFirstEvent, int val) {
        try {
            CompactEventBuilder builder = new CompactEventBuilder(44, order);
            builder.openBank(1, 0, DataType.BANK);
            builder.openBank(2, 0, DataType.INT32);
            builder.addIntData(new int[]{val, 2, 3});
            builder.closeAll();
            ByteBuffer bb = builder.getBuffer();
            PayloadBuffer pBuf = new PayloadBuffer(bb);
            pBuf.setEventType(EventType.USER);
            if (isFirstEvent) {
                pBuf.isFirstEvent(true);
            }
            return pBuf;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RocSimulation(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
        this.outputOrder = ByteOrder.LITTLE_ENDIAN;
        this.logger.info("  ROC Simulation: output byte order = " + this.outputOrder);
        this.syncBitCount = 5003;
        this.message = new cMsgMessage();
        this.message.setSubject("syncFromRoc");
        this.message.setType(emu.name());
        this.triggerType = 15;
        try {
            this.triggerType = Integer.parseInt(attributeMap.get("triggerType"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.triggerType < 0) {
            this.triggerType = 0;
        } else if (this.triggerType > 15) {
            this.triggerType = 15;
        }
        this.detectorId = 111;
        try {
            this.detectorId = Integer.parseInt(attributeMap.get("detectorId"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.detectorId < 0) {
            this.detectorId = 0;
        }
        this.eventBlockSize = 40;
        try {
            this.eventBlockSize = Integer.parseInt(attributeMap.get("blockSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.eventBlockSize < 1) {
            this.eventBlockSize = 1;
        } else if (this.eventBlockSize > 255) {
            this.eventBlockSize = 255;
        }
        this.eventSize = 75;
        try {
            this.eventSize = Integer.parseInt(attributeMap.get("eventSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.eventSize < 1) {
            this.eventSize = 1;
        }
        this.loops = 0;
        try {
            this.loops = Integer.parseInt(attributeMap.get("loops"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.loops < 1) {
            this.loops = 0;
        }
        this.syncCount = 20000;
        try {
            this.syncCount = Integer.parseInt(attributeMap.get("syncCount"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.syncCount < 10) {
            this.syncCount = 10;
        }
        this.synced = true;
        String s = attributeMap.get("sync");
        if (s != null && (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("off") || s.equalsIgnoreCase("no"))) {
            this.synced = false;
        }
        this.noPhysics = false;
        s = attributeMap.get("noPhysics");
        if (s != null && (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("yes"))) {
            this.noPhysics = true;
            this.eventProducingThreads = 1;
        }
        this.eventGeneratingThreads = new EventGeneratingThread[this.eventProducingThreads];
        emu.setCodaClass(CODAClass.ROC);
    }

    @Override
    public void addInputChannels(ArrayList<DataChannel> input_channels) {
    }

    @Override
    public ArrayList<DataChannel> getInputChannels() {
        return null;
    }

    @Override
    public void clearChannels() {
        this.outputChannels.clear();
    }

    @Override
    public int getInternalRingCount() {
        return this.bufSupplySize;
    }

    private void endThreads() {
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.RateCalculator = null;
        for (EventGeneratingThread thd : this.eventGeneratingThreads) {
            if (thd == null) continue;
            try {
                thd.interrupt();
                thd.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void killThreads() {
        if (this.RateCalculator != null) {
            this.RateCalculator.interrupt();
        }
        this.RateCalculator = null;
        for (EventGeneratingThread thd : this.eventGeneratingThreads) {
            if (thd == null) continue;
            thd.endThread();
            try {
                thd.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void eventToOutputRing(int ringNum, ByteBuffer buf, ByteBufferItem item, ByteBufferSupply bbSupply) {
        if (this.outputChannelCount < 1) {
            bbSupply.release(item);
            return;
        }
        RingBuffer<RingItem> rb = ((DataChannel)this.outputChannels.get(0)).getRingBuffersOut()[ringNum];
        long nextRingItem = rb.next();
        RingItem ri = (RingItem)rb.get(nextRingItem);
        ri.setBuffer(buf);
        ri.setEventType(EventType.ROC_RAW);
        ri.setControlType(null);
        ri.setSourceName(null);
        ri.setReusableByteBuffer(bbSupply, item);
        rb.publish(nextRingItem);
    }

    private void sendMsgToSynchronizer(boolean gotEnd) throws cMsgException {
        if (gotEnd) {
            this.message.setUserInt(1);
        } else {
            this.message.setUserInt(0);
        }
        this.cMsgServer.send(this.message);
    }

    private int getSingleEventBufferWords(int generatedDataWords) {
        int dataWordLength = 1 + generatedDataWords;
        return 6 + 4 * this.eventBlockSize + dataWordLength;
    }

    private ByteBuffer createSingleEventBuffer(int generatedDataWords, long eventNumber, long timestamp) {
        int writeIndex = 0;
        int dataLen = 1 + generatedDataWords;
        ByteBuffer buf = ByteBuffer.allocate(4 * this.eventWordSize);
        buf.order(this.outputOrder);
        int rocTag = Evio.createCodaTag(false, false, true, false, this.id);
        int secondWord = rocTag << 16 | DataType.BANK.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, this.eventWordSize - 1);
        buf.putInt(writeIndex += 4, secondWord);
        secondWord = CODATag.RAW_TRIGGER_TS.getValue() << 16 | DataType.SEGMENT.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex += 4, this.eventWordSize - 2 - dataLen - 2 - 1);
        buf.putInt(writeIndex += 4, secondWord);
        writeIndex += 4;
        int segWord = this.triggerType << 24 | DataType.UINT32.getValue() << 16 | 3;
        for (int i = 0; i < this.eventBlockSize; ++i) {
            buf.putInt(writeIndex, segWord);
            buf.putInt(writeIndex += 4, (int)(eventNumber + (long)i));
            buf.putInt(writeIndex += 4, (int)timestamp);
            buf.putInt(writeIndex += 4, (int)(timestamp >>> 32 & 0xFFFFL));
            writeIndex += 4;
            timestamp += 4L;
        }
        int dataTag = Evio.createCodaTag(false, false, true, false, this.detectorId);
        secondWord = dataTag << 16 | DataType.UINT32.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(writeIndex, dataLen + 1);
        buf.putInt(writeIndex += 4, secondWord);
        buf.putInt(writeIndex += 4, (int)eventNumber);
        writeIndex += 4;
        for (int i = 0; i < generatedDataWords; ++i) {
            buf.putInt(writeIndex, 1);
            writeIndex += 4;
        }
        return buf;
    }

    void writeEventBuffer(ByteBuffer buf, ByteBuffer templateBuf, long eventNumber, long timestamp, boolean syncBit, boolean copy) {
        if (copy) {
            if (!buf.hasArray()) {
                templateBuf.position(0);
                buf.put(templateBuf);
            } else {
                System.arraycopy(templateBuf.array(), 0, buf.array(), 0, templateBuf.limit());
            }
        }
        buf.position(0).limit(templateBuf.limit());
        int rocTag = Evio.createCodaTag(syncBit, false, true, false, this.id);
        int secondWord = rocTag << 16 | DataType.BANK.getValue() << 8 | this.eventBlockSize & 0xFF;
        buf.putInt(4, secondWord);
        int writeIndex = 16;
        for (int i = 0; i < this.eventBlockSize; ++i) {
            buf.putInt(writeIndex += 4, (int)(eventNumber + (long)i));
            buf.putInt(writeIndex += 4, (int)timestamp);
            buf.putInt(writeIndex += 4, (int)(timestamp >>> 32 & 0xFFFFL));
            writeIndex += 4;
            timestamp += 4L;
        }
        buf.putInt(writeIndex += 8, (int)eventNumber);
    }

    @Override
    public void reset() {
        this.gotResetCommand = true;
        System.out.println("  Roc mod: reset()");
        Date theDate = new Date();
        CODAStateIF previousState = this.moduleState;
        this.moduleState = CODAState.CONFIGURED;
        this.wordRate = 0.0f;
        this.eventRate = 0.0f;
        this.wordCountTotal = 0L;
        this.eventCountTotal = 0L;
        this.killThreads();
        if (this.synced) {
            try {
                if (this.cmsgSubHandle != null) {
                    this.cMsgServer.unsubscribe(this.cmsgSubHandle);
                    this.cmsgSubHandle = null;
                }
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        this.paused = false;
        if (previousState.equals(CODAState.ACTIVE)) {
            try {
                Configurer.setValue(this.emu.parameters(), "status/run_end_time", theDate.toString());
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void end() throws CmdExecException {
        this.paused = false;
        this.gotEndCommand = true;
        this.endCallback.endWait();
        if (this.gotGoCommand && this.synced) {
            try {
                this.endPhaser.awaitAdvanceInterruptibly(this.endPhaser.arrive());
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.moduleState = CODAState.DOWNLOADED;
        if (this.synced) {
            try {
                if (this.cmsgSubHandle != null) {
                    this.cMsgServer.unsubscribe(this.cmsgSubHandle);
                    this.cmsgSubHandle = null;
                }
            }
            catch (cMsgException e) {
                // empty catch block
            }
        }
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_end_time", new Date().toString());
        }
        catch (DataNotFoundException e) {
            // empty catch block
        }
        this.killThreads();
        PayloadBuffer pBuf = Evio.createControlBuffer(ControlType.END, 0, 0, (int)this.eventCountTotal, 0, this.outputOrder, false);
        for (int i = 0; i < this.outputChannelCount; ++i) {
            if (i > 0) {
                pBuf = new PayloadBuffer(pBuf);
            }
            try {
                this.eventToOutputChannel((RingItem)pBuf, i, 0);
            }
            catch (InterruptedException e) {
                return;
            }
            System.out.println("  Roc mod: inserted END event to channel " + i);
        }
    }

    @Override
    public void prestart() {
        this.moduleState = CODAState.PAUSED;
        this.gotResetCommand = false;
        this.gotEndCommand = false;
        this.gotGoCommand = false;
        this.wordRate = 0.0f;
        this.eventRate = 0.0f;
        this.wordCountTotal = 0L;
        this.eventCountTotal = 0L;
        this.rocRecordId = 1;
        if (this.synced) {
            this.phaser = new Phaser(this.eventProducingThreads + 1);
            this.endPhaser = new Phaser(this.eventProducingThreads + 2);
            this.timeToEnd = false;
            this.gotEndCommand = false;
        }
        this.RateCalculator = new Thread(this.emu.getThreadGroup(), new ModuleAdapter.RateCalculatorThread(), this.emu.name() + ":watcher");
        PayloadBuffer pBuf = Evio.createControlBuffer(ControlType.PRESTART, this.emu.getRunNumber(), this.emu.getRunTypeId(), 0, 0, this.outputOrder, false);
        for (int i = 0; i < this.outputChannelCount; ++i) {
            PayloadBuffer pBuf2 = new PayloadBuffer(pBuf);
            try {
                this.eventToOutputChannel((RingItem)pBuf2, i, 0);
            }
            catch (InterruptedException e) {
                return;
            }
            System.out.println("  Roc mod: inserted PRESTART event to channel " + i);
        }
        ++this.rocRecordId;
        try {
            System.out.println("  Roc mod: write USER event after prestart for Roc1");
            pBuf = RocSimulation.createUserBuffer(this.outputOrder, false, 5);
            this.eventToOutputChannel((RingItem)pBuf, 0, 0);
            ++this.rocRecordId;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ++this.eventCountTotal;
        this.wordCountTotal += 7L;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", "--prestart--");
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
        if (this.synced) {
            this.cMsgServer = this.emu.getCmsgPortal().getCmsgServer();
            try {
                this.cmsgSubHandle = this.cMsgServer.subscribe("sync", "ROC", (cMsgCallbackInterface)this.callback, null);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        System.out.println("AFTER PRESTART: rocRecordId = " + this.rocRecordId);
    }

    @Override
    public void go() {
        int i;
        this.gotGoCommand = true;
        if (this.moduleState == CODAState.ACTIVE) {
            // empty if block
        }
        PayloadBuffer pBuf = Evio.createControlBuffer(ControlType.GO, 0, 0, (int)this.eventCountTotal, 0, this.outputOrder, false);
        for (i = 0; i < this.outputChannelCount; ++i) {
            PayloadBuffer pBuf2 = new PayloadBuffer(pBuf);
            try {
                this.eventToOutputChannel((RingItem)pBuf2, i, 0);
            }
            catch (InterruptedException e) {
                return;
            }
            System.out.println("  Roc mod: inserted GO event to channel " + i);
        }
        ++this.rocRecordId;
        System.out.println("AFTER GO sent: rocRecordId = " + this.rocRecordId);
        this.moduleState = CODAState.ACTIVE;
        if (this.RateCalculator == null) {
            this.RateCalculator = new Thread(this.emu.getThreadGroup(), new ModuleAdapter.RateCalculatorThread(), this.emu.name() + ":watcher");
        }
        if (this.RateCalculator.getState() == Thread.State.NEW) {
            this.RateCalculator.start();
        }
        if (!this.noPhysics) {
            for (i = 0; i < this.eventProducingThreads; ++i) {
                if (this.eventGeneratingThreads[i] == null) {
                    this.eventGeneratingThreads[i] = new EventGeneratingThread(i, this.emu.getThreadGroup(), this.emu.name() + ":generator");
                } else if (!this.eventGeneratingThreads[i].isAlive()) {
                    this.eventGeneratingThreads[i] = new EventGeneratingThread(i, this.emu.getThreadGroup(), this.emu.name() + ":generator");
                }
                if (this.eventGeneratingThreads[i].getState() != Thread.State.NEW) continue;
                this.eventGeneratingThreads[i].start();
            }
        }
        this.paused = false;
        try {
            Configurer.setValue(this.emu.parameters(), "status/run_start_time", new Date().toString());
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    class EventGeneratingThread
    extends Thread {
        private final int myId;
        private int myRocRecordId;
        private long myEventNumber;
        private long timestamp;
        private ByteBufferSupply bbSupply;
        private int generatedDataWords;
        private ByteBuffer templateBuffer;
        private int templateBufferLimit;
        private volatile boolean killThd;

        EventGeneratingThread(int id, ThreadGroup group, String name) {
            super(group, name);
            this.myId = id;
            this.myRocRecordId = RocSimulation.this.rocRecordId + this.myId;
            System.out.println("  Roc mod: EventGeneratingThd constructor: rocRecordId = " + RocSimulation.this.rocRecordId);
            System.out.println("  Roc mod: EventGeneratingThd constructor: myRecordId = " + this.myRocRecordId);
            this.myEventNumber = 1L + (long)(this.myId * RocSimulation.this.eventBlockSize);
            this.timestamp = this.myId * 4 * RocSimulation.this.eventBlockSize;
            this.generatedDataWords = RocSimulation.this.eventBlockSize * RocSimulation.this.eventSize;
            System.out.println("  Roc mod: generatedDataWords = " + this.generatedDataWords);
            RocSimulation.this.eventWordSize = RocSimulation.this.getSingleEventBufferWords(this.generatedDataWords);
            System.out.println("  Roc mod: eventWordSize = " + RocSimulation.this.eventWordSize);
            this.templateBuffer = RocSimulation.this.createSingleEventBuffer(this.generatedDataWords, this.myEventNumber, this.timestamp);
            this.templateBufferLimit = this.templateBuffer.limit();
            System.out.println("  Roc mod: start With (id=" + this.myId + "):\n    record id = " + this.myRocRecordId + ", ev # = " + this.myEventNumber + ", ts = " + this.timestamp + ", blockSize = " + RocSimulation.this.eventBlockSize);
        }

        final void endThread() {
            this.killThd = true;
            this.interrupt();
        }

        @Override
        public void run() {
            boolean k = false;
            int skip = 3;
            int syncBitLoop = RocSimulation.this.syncBitCount;
            int userEventLoop = 5;
            long oldVal = 0L;
            long totalT = 0L;
            long totalCount = 0L;
            long bufCounter = 0L;
            ByteBuffer buf = null;
            ByteBufferItem bufItem = null;
            boolean copyWholeBuf = true;
            if (RocSimulation.this.outputChannelCount > 0) {
                RocSimulation.this.bufSupplySize = ((DataChannel)RocSimulation.this.outputChannels.get(0)).getRingBuffersOut()[0].getBufferSize();
            } else {
                RocSimulation.this.bufSupplySize = 4096;
            }
            this.bbSupply = new ByteBufferSupply(RocSimulation.this.bufSupplySize, 4 * RocSimulation.this.eventWordSize, ByteOrder.BIG_ENDIAN, false);
            try {
                long t1 = System.currentTimeMillis();
                boolean noBuildableEvents = false;
                System.out.println("\n\n  Roc mod: write USER event after go for Roc1 ***************\n");
                PayloadBuffer pBuf2 = RocSimulation.createUserBuffer(RocSimulation.this.outputOrder, false, 9);
                RocSimulation.this.eventToOutputChannel((RingItem)pBuf2, 0, 0);
                ++RocSimulation.this.eventCountTotal;
                RocSimulation.this.wordCountTotal += 7L;
                System.out.println("SETTING loops to " + RocSimulation.this.loops);
                while (RocSimulation.this.moduleState == CODAState.ACTIVE || RocSimulation.this.paused) {
                    if (RocSimulation.this.gotResetCommand) {
                        return;
                    }
                    if (noBuildableEvents) {
                        if (this.killThd) {
                            return;
                        }
                        Thread.sleep(500L);
                        if (RocSimulation.this.synced && --userEventLoop < 1) {
                            if (RocSimulation.this.moduleState == CODAState.DOWNLOADED) {
                                RocSimulation.this.gotEndCommand = true;
                            }
                            if (this.myId == 0) {
                                RocSimulation.this.sendMsgToSynchronizer(RocSimulation.this.gotEndCommand);
                            }
                            RocSimulation.this.phaser.arriveAndAwaitAdvance();
                            if (RocSimulation.this.timeToEnd) {
                                RocSimulation.this.endPhaser.arriveAndDeregister();
                                return;
                            }
                            userEventLoop = 5;
                        }
                    } else {
                        if (this.killThd) {
                            return;
                        }
                        bufItem = this.bbSupply.get();
                        buf = bufItem.getBuffer();
                        if (copyWholeBuf) {
                            buf.order(RocSimulation.this.outputOrder);
                            if (++bufCounter > (long)RocSimulation.this.bufSupplySize) {
                                copyWholeBuf = false;
                            }
                        }
                        if (--syncBitLoop == 0) {
                            syncBitLoop = RocSimulation.this.syncBitCount;
                            RocSimulation.this.writeEventBuffer(buf, this.templateBuffer, this.myEventNumber, this.timestamp, true, copyWholeBuf);
                        } else {
                            RocSimulation.this.writeEventBuffer(buf, this.templateBuffer, this.myEventNumber, this.timestamp, false, copyWholeBuf);
                        }
                        if (this.killThd) {
                            return;
                        }
                        RocSimulation.this.eventToOutputRing(this.myId, buf, bufItem, this.bbSupply);
                        RocSimulation.this.eventCountTotal += (long)RocSimulation.this.eventBlockSize;
                        RocSimulation.this.wordCountTotal += (long)RocSimulation.this.eventWordSize;
                        this.myEventNumber += (long)(RocSimulation.this.eventProducingThreads * RocSimulation.this.eventBlockSize);
                        this.timestamp += (long)(4 * RocSimulation.this.eventProducingThreads * RocSimulation.this.eventBlockSize);
                        if (RocSimulation.this.synced && --userEventLoop < 1) {
                            if (RocSimulation.this.moduleState == CODAState.DOWNLOADED) {
                                RocSimulation.this.gotEndCommand = true;
                            }
                            if (this.myId == 0) {
                                RocSimulation.this.sendMsgToSynchronizer(RocSimulation.this.gotEndCommand);
                            }
                            RocSimulation.this.phaser.arriveAndAwaitAdvance();
                            if (RocSimulation.this.timeToEnd) {
                                RocSimulation.this.endPhaser.arriveAndDeregister();
                                return;
                            }
                            userEventLoop = ++RocSimulation.this.syncCount;
                        }
                    }
                    long t2 = RocSimulation.this.emu.getTime();
                    long deltaT = t2 - t1;
                    if (this.myId != 0 || deltaT <= 2000L) continue;
                    if (skip-- < 1) {
                        System.out.println("  Roc mod: event rate = " + String.format("%.3g", (double)(this.myEventNumber - oldVal) * 1000.0 / (double)deltaT) + " Hz,  avg = " + String.format("%.3g", (double)(totalCount += this.myEventNumber - oldVal) * 1000.0 / (double)(totalT += deltaT)));
                    } else {
                        System.out.println("  Roc mod: event rate = " + String.format("%.3g", (double)(this.myEventNumber - oldVal) * 1000.0 / (double)deltaT) + " Hz");
                    }
                    t1 = t2;
                    oldVal = this.myEventNumber;
                }
            }
            catch (InterruptedException noBuildableEvents) {
            }
            catch (Exception e) {
                e.printStackTrace();
                RocSimulation.this.errorMsg.compareAndSet(null, e.getMessage());
                RocSimulation.this.moduleState = CODAState.ERROR;
                RocSimulation.this.emu.sendStatusMessage();
                return;
            }
        }
    }

    private class SyncCallback
    extends cMsgCallbackAdapter {
        private SyncCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            int endIt = msg.getUserInt();
            if (endIt > 0) {
                RocSimulation.this.timeToEnd = true;
                RocSimulation.this.endPhaser.arriveAndDeregister();
            }
            RocSimulation.this.phaser.arrive();
        }
    }
}

