/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu.modules;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import java.util.Map;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.modules.ModuleAdapter;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.data.ControlType;
import org.jlab.coda.emu.support.data.Evio;
import org.jlab.coda.emu.support.data.PayloadBuffer;
import org.jlab.coda.emu.support.data.RingItem;
import org.jlab.coda.emu.support.transport.DataChannel;

public class FarmController
extends ModuleAdapter {
    private EventMovingThread eventMovingThread;
    private boolean debug = false;
    private int runNumber;
    private int runTypeId;
    private RingBuffer<RingItem> ringBufferIn;
    private Sequence sequenceIn;
    private SequenceBarrier barrierIn;

    public FarmController(String name, Map<String, String> attributeMap, Emu emu) {
        super(name, attributeMap, emu);
    }

    @Override
    public void reset() {
        if (this.debug) {
            System.out.println("FarmController: reset");
        }
        this.moduleState = CODAState.CONFIGURED;
        this.paused = false;
        this.endThread();
    }

    @Override
    public void end() throws CmdExecException {
        if (this.debug) {
            System.out.println("FarmController: end");
        }
        this.moduleState = CODAState.DOWNLOADED;
        this.paused = false;
        this.endThread();
    }

    @Override
    public void prestart() throws CmdExecException {
        if (this.debug) {
            System.out.println("FarmController: prestart");
        }
        this.ringBufferIn = ((DataChannel)this.inputChannels.get(0)).getRingBufferIn();
        this.sequenceIn = new Sequence(-1L);
        this.ringBufferIn.addGatingSequences(new Sequence[]{this.sequenceIn});
        this.barrierIn = this.ringBufferIn.newBarrier(new Sequence[0]);
        this.wordRate = 0.0f;
        this.eventRate = 0.0f;
        this.wordCountTotal = 0L;
        this.eventCountTotal = 0L;
        this.moduleState = CODAState.PAUSED;
        this.eventMovingThread = new EventMovingThread();
        this.eventMovingThread.start();
        this.paused = true;
    }

    @Override
    public void pause() {
        super.pause();
        if (this.debug) {
            System.out.println("FarmController: pause");
        }
    }

    @Override
    public void go() throws CmdExecException {
        this.runNumber = this.emu.getRunNumber();
        this.runTypeId = this.emu.getRunTypeId();
        if (this.debug) {
            System.out.println("FarmController: go");
        }
        this.moduleState = CODAState.ACTIVE;
        this.paused = false;
    }

    private void endThread() {
        this.eventMovingThread.interrupt();
        try {
            this.eventMovingThread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class EventMovingThread
    extends Thread {
        private long availableSequence;
        private long nextSequence;

        EventMovingThread() {
            super(FarmController.this.emu.getThreadGroup(), FarmController.this.name + ":main");
        }

        @Override
        public void run() {
            boolean debug = false;
            FarmController.this.outputChannelCount = FarmController.this.outputChannels.size();
            this.availableSequence = -2L;
            this.nextSequence = FarmController.this.sequenceIn.get() + 1L;
            while (FarmController.this.moduleState == CODAState.ACTIVE || FarmController.this.paused) {
                try {
                    if (this.availableSequence < this.nextSequence) {
                        this.availableSequence = FarmController.this.barrierIn.waitFor(this.nextSequence);
                    }
                    RingItem ringItem = (RingItem)FarmController.this.ringBufferIn.get(this.nextSequence);
                    ControlType controlType = ringItem.getControlType();
                    FarmController.this.eventCountTotal += (long)ringItem.getEventCount();
                    FarmController.this.wordCountTotal += (long)(ringItem.getNode().getLength() + 1);
                    if (FarmController.this.outputChannelCount > 0) {
                        if (controlType == null) {
                            FarmController.this.eventToOutputChannel(ringItem, 0, 0);
                        } else {
                            for (int i = 0; i < FarmController.this.outputChannelCount; ++i) {
                                PayloadBuffer pBuf = Evio.createControlBuffer(controlType, FarmController.this.runNumber, FarmController.this.runTypeId, (int)FarmController.this.eventCountTotal, 0, FarmController.this.outputOrder, false);
                                FarmController.this.eventToOutputChannel((RingItem)pBuf, i, 0);
                            }
                        }
                    }
                    ringItem.releaseByteBuffer();
                    FarmController.this.sequenceIn.set(this.nextSequence++);
                    if (controlType != ControlType.END) continue;
                    if (FarmController.this.endCallback != null) {
                        FarmController.this.endCallback.endWait();
                    }
                    return;
                }
                catch (InterruptedException e) {
                    if (debug) {
                        System.out.println("  FCS mod: INTERRUPTED thread " + Thread.currentThread().getName());
                    }
                    return;
                }
                catch (AlertException e) {
                    if (debug) {
                        System.out.println("  FCS mod: Ring buf alert");
                    }
                    FarmController.this.emu.setErrorState("FCS Ring buf alert");
                    FarmController.this.moduleState = CODAState.ERROR;
                    return;
                }
                catch (TimeoutException e) {
                    if (debug) {
                        System.out.println("  FCS mod: Ring buf timeout");
                    }
                    FarmController.this.emu.setErrorState("FCS Ring buf timeout");
                    FarmController.this.moduleState = CODAState.ERROR;
                    return;
                }
                catch (Exception e) {
                    if (debug) {
                        System.out.println("  FCS mod: MAJOR ERROR: " + e.getMessage());
                    }
                    FarmController.this.moduleState = CODAState.ERROR;
                    FarmController.this.emu.setErrorState("FCS MAJOR ERROR: " + e.getMessage());
                    return;
                }
            }
        }
    }
}

