/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu;

import java.util.LinkedList;
import org.jlab.coda.emu.Emu;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.support.codaComponent.CODAClass;

public class EmuFactory {
    private LinkedList<String> names = new LinkedList();
    private LinkedList<String> types = new LinkedList();

    private static void decodeCommandLine(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("-h") && !arg.equalsIgnoreCase("-help")) continue;
            EmuFactory.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java EmuFactory\n        [-h]                 print this help\n        [-help]              print this help\n        [-Dname=xxx]         set name of EMU\n        [-Dtype=xxx]         set CODA component type (eg. PEB, ER)\n        [-Dexpid=xxx]        set experiment ID\n        [-Dsession=xxx]      set experimental session name\n        [-Duser.name=xxx]    set user's name (defaults to expid, then session)\n        [-DcmsgUDL=xxx]      set UDL to connect to cMsg server\n        [-DrcAddr=xxx]       set IP address to use with RC server\n        [-Ddebug=true]       turn on debug printout\n        [-DDebugUI]          display a control GUI\n");
    }

    public static void main(String[] args) {
        EmuFactory.decodeCommandLine(args);
        try {
            EmuFactory emuFactory = new EmuFactory();
            emuFactory.createEmus();
        }
        catch (EmuException e) {
            e.printStackTrace();
        }
    }

    public void createEmus() throws EmuException {
        String cmdLineNames;
        boolean debugUI = false;
        if (System.getProperty("DebugUI") != null) {
            debugUI = true;
        }
        if ((cmdLineNames = System.getProperty("name")) == null) {
            System.out.println("EMUFactory exit - must provide component name(s)");
            System.exit(-1);
        } else {
            String[] strs = cmdLineNames.contains(",") ? cmdLineNames.split(",") : (cmdLineNames.contains(":") ? cmdLineNames.split(":") : (cmdLineNames.contains(";") ? cmdLineNames.split(";") : new String[]{cmdLineNames}));
            System.out.println("Found names:");
            for (String s : strs) {
                if (this.names.contains(s)) {
                    System.out.println("EMUFactory exit - all component names must be unique, \"" + s + "\" is not");
                    System.exit(-1);
                }
                this.names.add(s);
                System.out.println("- " + s);
            }
        }
        String codaTypes = System.getProperty("type");
        if (codaTypes != null) {
            String[] strs = codaTypes.contains(",") ? codaTypes.split(",") : (codaTypes.contains(":") ? codaTypes.split(":") : (codaTypes.contains(";") ? codaTypes.split(";") : new String[]{codaTypes}));
            if (strs.length != this.names.size()) {
                System.out.println("EMUFactory exit - need 1 type for each component if specified on cmd line");
                System.exit(-1);
            }
            System.out.println("Found types:");
            for (int i = 0; i < strs.length; ++i) {
                if (CODAClass.get(strs[i]) == null) {
                    System.out.println("EMUFactory exit - all types must be valid, \"" + strs[i] + "\" is not");
                    System.exit(-1);
                }
                this.types.add(i, strs[i]);
                System.out.println("- " + strs[i]);
            }
        }
        boolean debugOn = false;
        String debug = System.getProperty("debug");
        if (debug != null && (debug.equalsIgnoreCase("on") || debug.equalsIgnoreCase("true"))) {
            debugOn = true;
        }
        for (int i = 0; i < this.names.size(); ++i) {
            if (this.types.size() > 0) {
                new Emu(this.names.get(i), this.types.get(i), debugUI, debugOn);
                continue;
            }
            new Emu(this.names.get(i), null, debugUI, debugOn);
        }
    }
}

