/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu;

import java.util.LinkedList;
import org.jlab.coda.emu.EmuModule;

public class EmuDataPath {
    private final LinkedList<Module> modules = new LinkedList();
    private final LinkedList<EmuModule> emuModules = new LinkedList();

    public EmuDataPath(String name, String inputFifo, String outputFifo) {
        this.addModuleName(name, inputFifo, outputFifo);
    }

    public synchronized boolean addModuleName(String name, String inputFifo, String outputFifo) {
        Module mod = new Module();
        mod.moduleName = name;
        mod.inputFifoName = inputFifo;
        mod.outputFifoName = outputFifo;
        if (inputFifo != null) {
            mod.hasInputFifo = true;
        }
        if (outputFifo != null) {
            mod.hasOutputFifo = true;
        }
        if (this.modules.size() < 1) {
            if (mod.hasInputFifo) {
                return false;
            }
            mod.isHead = true;
        } else {
            if (this.modules.getLast().outputFifoName == null) {
                return false;
            }
            if (!this.modules.getLast().outputFifoName.equals(inputFifo)) {
                return false;
            }
        }
        this.modules.add(mod);
        return true;
    }

    public synchronized void clear() {
        this.modules.clear();
        this.emuModules.clear();
    }

    public synchronized boolean associateModule(EmuModule module) {
        for (Module mod : this.modules) {
            if (!mod.moduleName.equals(module.name())) continue;
            mod.module = module;
            return true;
        }
        return false;
    }

    public synchronized LinkedList<Module> getModules() {
        return this.modules;
    }

    public synchronized LinkedList<EmuModule> getEmuModules() {
        this.emuModules.clear();
        for (Module mod : this.modules) {
            this.emuModules.add(mod.module);
        }
        return this.emuModules;
    }

    public synchronized boolean containsModuleName(String name) {
        for (Module mod : this.modules) {
            if (!mod.moduleName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean containsModule(EmuModule module) {
        this.getEmuModules();
        return this.emuModules.contains(module);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("input -> ");
        for (Module mod : this.modules) {
            sb.append(mod.moduleName);
            sb.append(" -> ");
        }
        sb.append(" output");
        return sb.toString();
    }

    class Module {
        boolean isHead;
        boolean hasInputFifo;
        boolean hasOutputFifo;
        EmuModule module;
        String moduleName;
        String inputFifoName;
        String outputFifoName;

        Module() {
        }
    }
}

