/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.emu;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.emu.EmuDataPath;
import org.jlab.coda.emu.EmuEventNotify;
import org.jlab.coda.emu.EmuException;
import org.jlab.coda.emu.EmuModule;
import org.jlab.coda.emu.modules.EventRecording;
import org.jlab.coda.emu.modules.FarmController;
import org.jlab.coda.emu.modules.FastEventBuilder;
import org.jlab.coda.emu.modules.RocSimulation;
import org.jlab.coda.emu.modules.TsSimulation;
import org.jlab.coda.emu.support.codaComponent.CODAClass;
import org.jlab.coda.emu.support.codaComponent.CODACommand;
import org.jlab.coda.emu.support.codaComponent.CODAComponent;
import org.jlab.coda.emu.support.codaComponent.CODAState;
import org.jlab.coda.emu.support.codaComponent.CODAStateIF;
import org.jlab.coda.emu.support.configurer.Configurer;
import org.jlab.coda.emu.support.configurer.DataNotFoundException;
import org.jlab.coda.emu.support.control.CmdExecException;
import org.jlab.coda.emu.support.control.Command;
import org.jlab.coda.emu.support.logger.Logger;
import org.jlab.coda.emu.support.messaging.CMSGPortal;
import org.jlab.coda.emu.support.transport.DataChannel;
import org.jlab.coda.emu.support.transport.DataTransport;
import org.jlab.coda.emu.support.transport.DataTransportImplFifo;
import org.jlab.coda.emu.support.ui.DebugFrame;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Emu
implements CODAComponent {
    private String name = "booted";
    private String expid;
    private String session;
    private String runType;
    private String hostName;
    private int codaid;
    private CODAClass codaClass = CODAClass.EMU;
    private String objectType = "coda3";
    private volatile int runNumber;
    private volatile int runTypeId;
    private volatile int bufferLevel;
    private boolean fileWritingOn = true;
    private DebugFrame debugGUI;
    private final ThreadGroup threadGroup;
    private long endingTimeLimit = 30000L;
    private volatile boolean resetting;
    private volatile boolean theEndIsNigh;
    private final CMSGPortal cmsgPortal;
    private String[] platformIpAddresses;
    private int platformTcpPort;
    private EmuDataPath dataPath;
    private boolean debug = false;
    protected AtomicReference<String> errorMsg = new AtomicReference();
    private boolean errorSent;
    private volatile CODAStateIF state = CODAState.BOOTED;
    private CODAStateIF previousState = CODAState.BOOTED;
    private final Logger logger;
    private String[] outputDestinations = null;
    private StatusReportingThread statusReportingThread;
    private int statusReportingPeriod = 2000;
    private volatile boolean statusReportingOn;
    private final CopyOnWriteArrayList<EmuModule> modules = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<DataChannel> inChannels = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<DataChannel> outChannels = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<DataChannel> fifoChannels = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<DataTransport> transports = new CopyOnWriteArrayList();
    private DataTransportImplFifo fifoTransport;
    private int dataStreamCount = 1;
    private int dataStreamId;
    private int fileOutputCount;
    private int firstModuleInputChannelCount;
    private ConfigSource configSource;
    private long configFileModifiedTime;
    private Document loadedConfig;
    private String msgConfigFile;
    private Document localConfig;
    private String localConfigXML = "<?xml version=\"1.0\"?>\n<status state=\"\" eventCount=\"0\" wordCount=\"0\" run_number=\"0\" run_type=\"unknown\" run_start_time=\"unknown\" run_end_time=\"unknown\"/>";
    private boolean lastConfigHadError;
    private ArrayBlockingQueue<Command> mailbox;
    private Command[] rcCommands;
    private int rcCommandIndex;
    private TransitionExecutor transitionRunnable;
    private Thread transitionThread;

    public Emu(String name, String type, boolean debugUI, boolean debug) throws EmuException {
        String tmp;
        CODAClass cc;
        if (name == null) {
            throw new EmuException("Emu name not defined");
        }
        if (type != null && (cc = CODAClass.get(type)) != null) {
            this.codaClass = cc;
        }
        System.out.println("Emu created, name = " + name + ", type = " + (Object)((Object)this.codaClass));
        this.debug = debug;
        this.name = name;
        if (this.debugGUI != null) {
            this.debugGUI.setTitle(name);
        }
        this.logger = new Logger();
        Configurer.setLogger(this.logger);
        HashMap<String, String> attrs = new HashMap<String, String>(2);
        attrs.put("class", "Fifo");
        attrs.put("server", "false");
        try {
            this.fifoTransport = new DataTransportImplFifo("Fifo", attrs, null);
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
        this.threadGroup = new ThreadGroup(name);
        if (debugUI) {
            this.debugGUI = new DebugFrame(this);
        }
        this.mailbox = new ArrayBlockingQueue(4);
        this.rcCommands = new Command[100];
        this.transitionRunnable = new TransitionExecutor();
        this.transitionThread = new Thread(this.threadGroup, this.transitionRunnable, "Transition command executor");
        this.transitionThread.start();
        this.statusReportingThread = new StatusReportingThread();
        new Thread(this.threadGroup, this.statusReportingThread, "Statistics reporting").start();
        if (this.debugGUI != null) {
            try {
                this.localConfig = Configurer.parseString(this.localConfigXML);
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
            this.debugGUI.addDocument(this.localConfig);
            this.debugGUI.generateInputPanel();
        }
        this.expid = (tmp = System.getProperty("expid")) != null ? tmp : System.getenv("EXPID");
        if (this.expid == null) {
            this.expid = "unknown";
        }
        this.session = (tmp = System.getProperty("session")) != null ? tmp : "unknown";
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "unknown";
        }
        this.cmsgPortal = new CMSGPortal(this);
        Configurer.setLogger(null);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int getCodaid() {
        return this.codaid;
    }

    @Override
    public void setCodaid(int codaid) {
        this.codaid = codaid;
    }

    @Override
    public String getSession() {
        return this.session;
    }

    @Override
    public String getExpid() {
        return this.expid;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public CODAClass getCodaClass() {
        return this.codaClass;
    }

    @Override
    public int getRunNumber() {
        return this.runNumber;
    }

    @Override
    public int getRunTypeId() {
        return this.runTypeId;
    }

    @Override
    public String getRunType() {
        return this.runType;
    }

    @Override
    public String getCmsgUDL() {
        return this.cmsgPortal.getRcUDL();
    }

    public String[] getPlatformIpAddresses() {
        return this.platformIpAddresses;
    }

    public int getPlatformTcpPort() {
        return this.platformTcpPort;
    }

    public int getBufferLevel() {
        return this.bufferLevel;
    }

    public void setBufferLevel(int bufferLevel) {
        this.bufferLevel = bufferLevel;
    }

    @Override
    public Document configuration() {
        return this.loadedConfig;
    }

    @Override
    public Document parameters() {
        return this.localConfig;
    }

    @Override
    public void setRunNumber(int runNumber) {
        this.runNumber = runNumber;
    }

    @Override
    public void setRunTypeId(int runTypeId) {
        this.runTypeId = runTypeId;
    }

    @Override
    public void setRunType(String runType) {
        this.runType = runType;
    }

    public CODAClass getCodaClassObject() {
        return this.codaClass;
    }

    public void setCodaClass(CODAClass codaClass) {
        this.codaClass = codaClass;
    }

    public boolean isFileWritingOn() {
        return this.fileWritingOn;
    }

    public DebugFrame getFramework() {
        return this.debugGUI;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CMSGPortal getCmsgPortal() {
        return this.cmsgPortal;
    }

    public long getEndingTimeLimit() {
        return this.endingTimeLimit;
    }

    EmuDataPath getDataPath() {
        return this.dataPath;
    }

    void setDataPath(EmuDataPath dataPath) {
        this.dataPath = dataPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmuModule getStatisticsModule() {
        CopyOnWriteArrayList<EmuModule> copyOnWriteArrayList = this.modules;
        synchronized (copyOnWriteArrayList) {
            if (this.modules.size() < 1) {
                return null;
            }
            return this.modules.get(this.modules.size() - 1);
        }
    }

    public int getInputChannelCount() {
        return this.firstModuleInputChannelCount;
    }

    public List<DataChannel> getInChannels() {
        return this.inChannels;
    }

    public List<DataChannel> getOutChannels() {
        return this.outChannels;
    }

    public int getDataStreamId() {
        return this.dataStreamId;
    }

    public int getDataStreamCount() {
        return this.dataStreamCount;
    }

    public int getFileOutputCount() {
        return this.fileOutputCount;
    }

    public boolean theEndIsNigh() {
        return this.theEndIsNigh;
    }

    public CODAStateIF previousState() {
        return this.previousState;
    }

    @Override
    public String getError() {
        return this.errorMsg.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(CODAStateIF state) {
        if (this.resetting) {
            return;
        }
        Emu emu = this;
        synchronized (emu) {
            this.state = state;
        }
        this.logger.info("Emu " + this.name + ": state set to " + state.name());
        System.out.println("\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorState(String errorCause) {
        if (this.resetting) {
            return;
        }
        Emu emu = this;
        synchronized (emu) {
            this.state = CODAState.ERROR;
            this.errorMsg.compareAndSet(null, errorCause);
            if (!this.errorSent) {
                this.sendRcErrorMessage(errorCause);
                this.sendStatusMessage();
                this.errorSent = true;
            }
            this.logger.error("Emu " + this.name + ": state set to ERROR");
            System.out.println("\n\n");
        }
    }

    @Override
    public CODAStateIF state() {
        return this.state;
    }

    public void sendRcInfoMessage(String msg) {
        this.cmsgPortal.rcGuiInfoMessage(msg);
    }

    public void sendRcWarningMessage(String msg) {
        this.cmsgPortal.rcGuiWarningMessage(msg);
    }

    public void sendRcErrorMessage(String error) {
        this.cmsgPortal.rcGuiErrorMessage(error);
    }

    public void sendRcSevereMessage(String error) {
        this.cmsgPortal.rcGuiSevereMessage(error);
    }

    public synchronized int addOutputDestination(String outputDestination) {
        int destCount = 0;
        if (this.outputDestinations == null) {
            this.outputDestinations = new String[1];
            this.outputDestinations[0] = outputDestination;
        } else {
            destCount = this.outputDestinations.length;
            String[] temp = new String[destCount + 1];
            System.arraycopy(this.outputDestinations, 0, temp, 0, destCount);
            temp[destCount] = outputDestination;
            this.outputDestinations = temp;
        }
        return destCount;
    }

    public synchronized void setOutputDestination(int index, String outputDestination) {
        if (this.outputDestinations == null || this.outputDestinations.length < index + 1) {
            return;
        }
        this.outputDestinations[index] = outputDestination;
    }

    public synchronized void clearOutputDestinations() {
        this.outputDestinations = null;
    }

    public void sendStatusMessage() {
        this.statusReportingThread.sendStatusMessage();
    }

    public long getTime() {
        return this.statusReportingThread.getTime();
    }

    @Override
    public void postCommand(Command cmd) throws InterruptedException {
        this.mailbox.put(cmd);
    }

    void quit() {
        this.logger.info("Emu " + this.name + " quitting");
        this.reset(false);
        this.statusReportingThread.interrupt();
        try {
            this.cmsgPortal.shutdown();
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        if (this.debugGUI != null) {
            this.debugGUI.dispose();
        }
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    private synchronized void reset(boolean restartTransitionThd) {
        this.logger.info("Emu " + this.name + " resetting");
        this.resetting = true;
        this.state = CODAState.RESETTING;
        this.clearOutputDestinations();
        this.transitionRunnable.stop();
        this.errorSent = false;
        this.errorMsg.set(null);
        this.mailbox.clear();
        if (this.inChannels.size() > 0) {
            for (DataChannel chan : this.inChannels) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " reset: reset in chan " + chan.name());
                }
                chan.reset();
            }
        }
        for (EmuModule module : this.modules) {
            if (this.debug) {
                System.out.println("Emu " + this.name + " reset: try to reset module " + module.name());
            }
            module.reset();
        }
        for (DataChannel chan : this.fifoChannels) {
            System.out.println("Emu " + this.name + ": reset FIFO chan " + chan.name());
            chan.reset();
        }
        if (this.outChannels.size() > 0) {
            for (DataChannel chan : this.outChannels) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + ": reset out chan " + chan.name());
                }
                chan.reset();
            }
        }
        for (DataTransport t : this.transports) {
            if (this.debug) {
                System.out.println("Emu " + this.name + " reset: reset transport " + t.name());
            }
            t.reset();
        }
        this.fifoTransport.reset();
        this.state = this.previousState == CODAState.ERROR || this.previousState == CODAState.BOOTED ? CODAState.BOOTED : CODAState.CONFIGURED;
        this.logger.info("Emu " + this.name + " reset: done, setting state to " + this.state);
        if (restartTransitionThd) {
            this.transitionRunnable = new TransitionExecutor();
            this.transitionThread = new Thread(this.threadGroup, this.transitionRunnable, "Transition command executor");
            this.transitionThread.start();
        }
        System.gc();
        this.resetting = false;
    }

    private DataTransport findTransport(String name) throws DataNotFoundException {
        if (!this.transports.isEmpty()) {
            for (DataTransport transport : this.transports) {
                DataTransport t = transport;
                if (!t.name().equals(name)) continue;
                return t;
            }
        }
        if (this.fifoTransport.name().equals(name)) {
            return this.fifoTransport;
        }
        throw new DataNotFoundException("Data Transport not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmuModule findModule(String name) {
        CopyOnWriteArrayList<EmuModule> copyOnWriteArrayList = this.modules;
        synchronized (copyOnWriteArrayList) {
            for (EmuModule module : this.modules) {
                if (!module.name().equals(name)) continue;
                return module;
            }
        }
        return null;
    }

    private void replyToRunControl(String type, String payloadName, String val, cMsgMessage rcMsg) {
        if (val == null) {
            System.out.println("Emu " + this.name + ": cannot send cMsg msg since type is null");
            return;
        }
        cMsgMessage msg = null;
        if (rcMsg.isGetRequest()) {
            try {
                msg = rcMsg.response();
            }
            catch (cMsgException cMsgException2) {}
        } else {
            msg = new cMsgMessage();
            msg.setSubject(this.name);
            msg.setType(type);
            return;
        }
        if (payloadName == null) {
            msg.setText(val);
        } else {
            try {
                cMsgPayloadItem item = new cMsgPayloadItem(payloadName, val);
                msg.addPayloadItem(item);
            }
            catch (cMsgException item) {
                // empty catch block
            }
        }
        try {
            this.cmsgPortal.getRcServer().send(msg);
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
    }

    private void replyToRunControl(String type, String payloadName, int val, cMsgMessage rcMsg) {
        cMsgMessage msg = null;
        if (rcMsg.isGetRequest()) {
            try {
                msg = rcMsg.response();
            }
            catch (cMsgException cMsgException2) {}
        } else {
            msg = new cMsgMessage();
            msg.setSubject(this.name);
            msg.setType(type);
            return;
        }
        if (payloadName == null) {
            msg.setUserInt(val);
        } else {
            try {
                cMsgPayloadItem item = new cMsgPayloadItem(payloadName, val);
                msg.addPayloadItem(item);
            }
            catch (cMsgException item) {
                // empty catch block
            }
        }
        try {
            this.cmsgPortal.getRcServer().send(msg);
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
    }

    private void replyToRunControl(String type, String payloadName, long val, cMsgMessage rcMsg) {
        if (payloadName == null) {
            return;
        }
        cMsgMessage msg = null;
        if (rcMsg.isGetRequest()) {
            try {
                msg = rcMsg.response();
            }
            catch (cMsgException cMsgException2) {}
        } else {
            msg = new cMsgMessage();
            msg.setSubject(this.name);
            msg.setType(type);
            return;
        }
        try {
            cMsgPayloadItem item = new cMsgPayloadItem(payloadName, val);
            msg.addPayloadItem(item);
        }
        catch (cMsgException item) {
            // empty catch block
        }
        try {
            this.cmsgPortal.getRcServer().send(msg);
        }
        catch (cMsgException e) {
            e.printStackTrace();
        }
    }

    public void execute(Command cmd) {
        System.out.println("Emu " + this.name + ": start executing cmd = " + cmd.name());
        if (this.resetting) {
            System.out.println("Emu " + this.name + ": do not execute cmd = " + cmd.name() + ", resetting");
            return;
        }
        CODACommand codaCommand = cmd.getCodaCommand();
        try {
            if (codaCommand == CODACommand.START_REPORTING) {
                this.statusReportingOn = true;
                return;
            }
            if (codaCommand == CODACommand.STOP_REPORTING) {
                this.statusReportingOn = false;
                return;
            }
            if (codaCommand == CODACommand.SET_PRE_END) {
                this.theEndIsNigh = true;
                return;
            }
            if (codaCommand == CODACommand.SET_SESSION) {
                cMsgPayloadItem pItem = cmd.getArg("session");
                if (pItem != null) {
                    try {
                        this.session = pItem.getString();
                        if (this.debug) {
                            System.out.println("Emu " + this.name + " SET_SESSION: set to " + this.session);
                        }
                    }
                    catch (cMsgException e) {
                        this.logger.error("Got SET_SESSION command but no session specified 1");
                    }
                } else {
                    this.logger.error("Got SET_SESSION command but no session specified 2");
                }
                return;
            }
            if (codaCommand == CODACommand.SET_RUN_TYPE) {
                cMsgPayloadItem pItem = cmd.getArg("config");
                if (pItem != null) {
                    try {
                        String txt;
                        this.runType = txt = pItem.getString();
                        if (this.debug) {
                            System.out.println("Emu " + this.name + " SET_RUN_TYPE: set to " + txt);
                        }
                    }
                    catch (cMsgException e) {
                        this.logger.error("Emu " + this.name + ": got SET_RUN_TYPE command but no run type specified 1");
                    }
                } else {
                    this.logger.error("Emu " + this.name + ": got SET_RUN_TYPE command but no run type specified 2");
                }
                return;
            }
            if (codaCommand == CODACommand.SET_BUF_LEVEL) {
                int bufLevel = cmd.getMessage().getUserInt();
                if (bufLevel > 0) {
                    this.bufferLevel = bufLevel;
                } else {
                    this.logger.error("Emu " + this.name + ": got SET_BUF_LEVEL command but bad value (" + bufLevel + ')');
                }
                return;
            }
            if (codaCommand == CODACommand.GET_STATE) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getState", null, this.state().name().toLowerCase(), cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.GET_CODA_CLASS) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getCodaClass", null, this.codaClass.name(), cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.GET_OBJECT_TYPE) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getObjectType", null, this.objectType, cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.GET_SESSION) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getSession", null, this.session, cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.GET_RUN_NUMBER) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getRunNumber", "runNumber", (long)this.runNumber, cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.GET_RUN_TYPE) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getRunType", null, this.runType, cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.GET_CONFIG_ID) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getConfigId", (String)null, this.codaid, cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.GET_BUF_LEVEL) {
                if (this.cmsgPortal != null && this.cmsgPortal.getRcServer() != null && this.cmsgPortal.getRcServer().isConnected()) {
                    this.replyToRunControl("rc/response/getRocBufferLevel", (String)null, this.bufferLevel, cmd.getMessage());
                }
                return;
            }
            if (codaCommand == CODACommand.EXIT) {
                this.quit();
                return;
            }
            if (codaCommand.isTransition()) {
                this.previousState = this.state;
            }
            if (codaCommand == CODACommand.CONFIGURE) {
                this.configure(cmd);
            } else if (codaCommand == CODACommand.DOWNLOAD) {
                this.download(cmd);
            } else if (codaCommand == CODACommand.PRESTART) {
                this.prestart(cmd);
            } else if (codaCommand == CODACommand.GO) {
                this.go();
            } else if (codaCommand == CODACommand.END) {
                this.end();
            }
            if (this.state == CODAState.ERROR) {
                this.logger.error("Emu " + this.name + ": transition NOT successful, state = ERROR");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void end() {
        boolean debugOrig = this.debug;
        this.logger.info("Emu " + this.name + " end: change state to ENDING");
        this.setState(CODAState.ENDING);
        this.clearOutputDestinations();
        long timeout = this.endingTimeLimit;
        TimeUnit timeUnits = TimeUnit.MILLISECONDS;
        try {
            if (this.codaClass == CODAClass.TS) {
                this.modules.get(0).end();
                if (this.debug) {
                    System.out.println("Emu " + this.name + " end: END cmd to module " + this.modules.get(0).name());
                }
                this.setState(CODAState.DOWNLOADED);
                return;
            }
            LinkedList<EmuModule> mods = this.dataPath.getEmuModules();
            if (mods.size() < 1) {
                throw new CmdExecException("no modules in data path");
            }
            for (EmuModule mod : mods) {
                Class<?> c = mod.getClass();
                if (!c.getName().equals("org.jlab.coda.emu.modules.RocSimulation") && !c.getName().equals("org.jlab.coda.emu.modules.RocFixedRateSimulation")) continue;
                if (this.debug) {
                    System.out.println("Emu " + this.name + " end: call end() in fake ROC " + mod.name());
                }
                mod.end();
                if (!this.debug) break;
                System.out.println("Emu " + this.name + " end: end() done in fake ROC " + mod.name());
                break;
            }
            boolean gotEndEvent = true;
            boolean gotAllEnds = true;
            if (this.inChannels.size() > 0) {
                for (DataChannel chan : this.inChannels) {
                    if (this.debug) {
                        System.out.println("Emu " + this.name + " end: in chan " + chan.name() + " wait for END event");
                    }
                    chan.getEndCallback().waitForEvent();
                    if (!this.debug) continue;
                    System.out.println("Emu " + this.name + " end: in chan " + chan.name() + " got END event");
                }
            }
            if (gotAllEnds) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " end: wait for END event in module " + mods.getLast().name());
                }
                mods.getLast().getEndCallback().waitForEvent();
                if (this.debug) {
                    System.out.println("Emu " + this.name + " end: got END event in module " + mods.getLast().name());
                }
                if (gotAllEnds && this.outChannels.size() > 0) {
                    for (DataChannel chan : this.outChannels) {
                        if (this.debug) {
                            System.out.println("Emu " + this.name + " end: output chan " + chan.name() + " wait for END event");
                        }
                        chan.getEndCallback().waitForEvent();
                        if (!this.debug) continue;
                        System.out.println("Emu " + this.name + " end: output chan " + chan.name() + " got END event");
                    }
                }
            }
            if (!gotAllEnds) {
                this.logger.error("Emu " + this.name + " end: END event did NOT make it through EMU");
            }
            if (this.inChannels.size() > 0) {
                for (DataChannel chan : this.inChannels) {
                    if (this.debug) {
                        System.out.println("Emu " + this.name + " end: END cmd to in chan " + chan.name());
                    }
                    chan.end();
                }
            }
            for (EmuModule mod : mods) {
                if (mod.getClass().getName().equals("org.jlab.coda.emu.modules.RocSimulation") || mod.getClass().getName().equals("org.jlab.coda.emu.modules.RocFixedRateSimulation")) continue;
                if (this.debug) {
                    System.out.println("Emu " + this.name + " end: END cmd to module " + mod.name());
                }
                mod.end();
            }
            if (this.outChannels.size() > 0) {
                for (DataChannel chan : this.outChannels) {
                    if (this.debug) {
                        System.out.println("Emu " + this.name + " end: END cmd to out chan " + chan.name());
                    }
                    chan.end();
                }
            }
            for (DataTransport transport : this.transports) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " end: END cmd to transport " + transport.name());
                }
                transport.end();
            }
            this.fifoTransport.end();
            System.gc();
        }
        catch (InterruptedException e) {
            System.out.println("Emu " + this.name + " end: interrupted, returning");
            System.gc();
            return;
        }
        catch (OutOfMemoryError e) {
            System.out.println("Emu " + this.name + " end: jvm out of memory, exiting");
            this.setErrorState("Emu " + this.name + " end: jvm out of memory, exiting");
            System.exit(-1);
        }
        catch (CmdExecException e) {
            System.out.println("Emu " + this.name + " end: " + e.getMessage());
            this.setErrorState("Emu " + this.name + " end:" + e.getMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Emu " + this.name + " end: " + e.getMessage());
            this.setErrorState("Emu " + this.name + " end:" + e.getMessage());
            return;
        }
        this.debug = debugOrig;
        if (this.state == CODAState.ERROR) {
            return;
        }
        System.out.println("Emu " + this.name + " end: try setting state to DOWNLOADED");
        this.theEndIsNigh = false;
        this.setState(CODAState.DOWNLOADED);
    }

    private void go() {
        this.logger.info("Emu " + this.name + " go: change state to GOING");
        this.setState(CODAState.ACTIVATING);
        if (this.codaClass == CODAClass.DC || this.codaClass == CODAClass.ER || this.codaClass == CODAClass.SEB || this.codaClass == CODAClass.PEB || this.codaClass == CODAClass.PEBER || this.codaClass == CODAClass.SEBER) {
            try {
                Iterator<DataChannel> mod = this.modules.get(this.modules.size() - 1);
                System.out.println("Emu " + this.name + " go: waiting for PRESTART event in module " + mod.name());
                this.sendRcInfoMessage("Emu " + this.name + " go: waiting for PRESTART event in module " + mod.name());
                mod.getPrestartCallback().waitForEvent();
                System.out.println("Emu " + this.name + " go: got PRESTART event in module " + mod.name());
            }
            catch (InterruptedException mod) {
                // empty catch block
            }
        }
        try {
            if (this.codaClass == CODAClass.TS) {
                this.modules.get(0).go();
                if (this.debug) {
                    System.out.println("Emu " + this.name + " go: GO cmd to module " + this.modules.get(0).name());
                }
                this.setState(CODAState.ACTIVE);
                return;
            }
            if (this.modules.size() < 1) {
                throw new CmdExecException("no modules in data path");
            }
            for (DataTransport transport : this.transports) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " go: GO cmd to transport " + transport.name());
                }
                transport.go();
            }
            if (this.outChannels.size() > 0) {
                for (DataChannel chan : this.outChannels) {
                    if (this.debug) {
                        System.out.println("Emu " + this.name + " go: GO cmd to OUT chan " + chan.name());
                    }
                    chan.go();
                }
            }
            for (DataChannel chan : this.fifoChannels) {
                System.out.println("Emu " + this.name + " go: GO cmd to FIFO chan " + chan.name());
                chan.prestart();
            }
            ListIterator<EmuModule> it = this.modules.listIterator(this.modules.size());
            while (it.hasPrevious()) {
                EmuModule mod = it.previous();
                if (this.debug) {
                    System.out.println("Emu " + this.name + " go: GO cmd to module " + mod.name());
                }
                mod.go();
            }
            if (this.inChannels.size() > 0) {
                for (DataChannel chan : this.inChannels) {
                    if (this.debug) {
                        System.out.println("Emu " + this.name + " go: GO cmd to IN chan " + chan.name());
                    }
                    chan.go();
                }
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("Emu " + this.name + " go: jvm out of memory, exiting");
            this.setErrorState("Emu " + this.name + " go: jvm out of memory, exiting");
            System.exit(-1);
        }
        catch (CmdExecException e) {
            System.out.println("Emu " + this.name + " go: " + e.getMessage());
            this.setErrorState("Emu " + this.name + " go: " + e.getMessage());
            return;
        }
        if (this.state == CODAState.ERROR) {
            return;
        }
        this.setState(CODAState.ACTIVE);
    }

    private void prestart(Command cmd) {
        cMsgPayloadItem pItem;
        this.logger.info("Emu " + this.name + " prestart: change state to PRESTARTING");
        this.setState(CODAState.PRESTARTING);
        cMsgMessage msg = cmd.getMessage();
        if (msg != null) {
            try {
                pItem = cmd.getArg("runNumber");
                if (pItem != null) {
                    this.runNumber = pItem.getInt();
                }
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
            try {
                pItem = cmd.getArg("fileWriting");
                if (pItem != null) {
                    this.fileWritingOn = pItem.getInt() != 0;
                }
            }
            catch (cMsgException cMsgException3) {
                // empty catch block
            }
        }
        try {
            if (this.codaClass == CODAClass.TS) {
                this.modules.get(0).prestart();
                if (this.debug) {
                    System.out.println("Emu " + this.name + " prestart: PRESTART cmd to module " + this.modules.get(0).name());
                }
                this.setState(CODAState.PAUSED);
                return;
            }
            for (DataTransport transport : this.transports) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " prestart: PRESTART cmd to " + transport.name());
                }
                transport.prestart();
            }
            this.inChannels.clear();
            this.outChannels.clear();
            this.fifoChannels.clear();
            Node modulesConfig = Configurer.getNode(this.configuration(), "component/modules");
            Node moduleNode = modulesConfig.getFirstChild();
            do {
                if (moduleNode.getNodeType() != 1 || !moduleNode.hasChildNodes()) continue;
                EmuModule module = this.findModule(moduleNode.getNodeName());
                if (module == null) {
                    throw new DataNotFoundException("module corresponding to " + moduleNode.getNodeName() + " not found");
                }
                module.clearChannels();
                System.gc();
                ArrayList<DataChannel> in = new ArrayList<DataChannel>(16);
                ArrayList<DataChannel> out = new ArrayList<DataChannel>(4);
                ArrayList<DataChannel> inFifo = new ArrayList<DataChannel>(2);
                ArrayList<DataChannel> outFifo = new ArrayList<DataChannel>(2);
                int outputChannelCount = 0;
                NodeList childList = moduleNode.getChildNodes();
                for (int i = 0; i < childList.getLength(); ++i) {
                    Node channelNameNode;
                    NamedNodeMap nnm;
                    Node channelNode = childList.item(i);
                    if (channelNode.getNodeType() != 1 || (nnm = channelNode.getAttributes()) == null || (channelNameNode = nnm.getNamedItem("name")) == null) continue;
                    String channelName = channelNameNode.getNodeValue();
                    Node channelTranspNode = nnm.getNamedItem("transp");
                    if (channelTranspNode == null) continue;
                    String channelTransName = channelTranspNode.getNodeValue();
                    DataTransport trans = this.findTransport(channelTransName);
                    HashMap<String, String> attributeMap = new HashMap<String, String>(8);
                    for (int j = 0; j < nnm.getLength(); ++j) {
                        Node a = nnm.item(j);
                        attributeMap.put(a.getNodeName(), a.getNodeValue());
                    }
                    if (channelNode.getNodeName().equalsIgnoreCase("inchannel")) {
                        DataChannel channel = trans.createChannel(channelName, attributeMap, true, this, module, 0);
                        if (channelTransName.equals("Fifo")) {
                            channel.registerEndCallback(null);
                            channel.registerPrestartCallback(null);
                            inFifo.add(channel);
                            continue;
                        }
                        if (channel == null) continue;
                        channel.registerEndCallback(new EmuEventNotify());
                        channel.registerPrestartCallback(new EmuEventNotify());
                        in.add(channel);
                        continue;
                    }
                    if (!channelNode.getNodeName().equalsIgnoreCase("outchannel")) continue;
                    DataChannel channel = trans.createChannel(channelName, attributeMap, false, this, module, outputChannelCount++);
                    if (channelTransName.equals("Fifo")) {
                        channel.registerEndCallback(null);
                        channel.registerPrestartCallback(null);
                        outFifo.add(channel);
                        continue;
                    }
                    if (channel == null) continue;
                    pItem = cmd.getArg("ipList_" + channelName);
                    if (pItem != null) {
                        String[] ipList = pItem.getStringArray();
                        System.out.println("Found destination IP list:");
                        for (String ip : ipList) {
                            System.out.println("  " + ip);
                        }
                        channel.setDestinationIpList(ipList);
                    }
                    if ((pItem = cmd.getArg("baList_" + channelName)) != null) {
                        String[] baList = pItem.getStringArray();
                        System.out.println("Found destination broadcast list:");
                        for (String ip : baList) {
                            System.out.println("  " + ip);
                        }
                        channel.setDestinationBaList(baList);
                    }
                    channel.registerEndCallback(new EmuEventNotify());
                    channel.registerPrestartCallback(new EmuEventNotify());
                    out.add(channel);
                }
                module.addInputChannels(in);
                module.addInputChannels(inFifo);
                module.addOutputChannels(out);
                module.addOutputChannels(outFifo);
                this.inChannels.addAll(in);
                this.outChannels.addAll(out);
                this.fifoChannels.addAll(outFifo);
            } while ((moduleNode = moduleNode.getNextSibling()) != null);
            for (DataChannel chan : this.outChannels) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " prestart: PRESTART cmd to OUT chan " + chan.name());
                }
                chan.prestart();
            }
            for (DataChannel chan : this.fifoChannels) {
                System.out.println("Emu " + this.name + " prestart: PRESTART cmd to FIFO chan " + chan.name());
                chan.prestart();
            }
            ListIterator<EmuModule> it = this.modules.listIterator(this.modules.size());
            while (it.hasPrevious()) {
                EmuModule mod = it.previous();
                mod.getEndCallback().reset();
                mod.getPrestartCallback().reset();
                System.out.println("Emu " + this.name + " prestart: PRESTART cmd to module " + mod.name());
                mod.prestart();
            }
            for (DataChannel chan : this.inChannels) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " prestart: PRESTART cmd to IN chan " + chan.name());
                }
                chan.prestart();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("Emu " + this.name + " prestart: jvm out of memory, exiting");
            this.setErrorState("Emu " + this.name + " prestart: jvm out of memory, exiting");
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Emu " + this.name + " prestart: " + e.getMessage());
            this.setErrorState("Emu " + this.name + " prestart: " + e.getMessage());
            return;
        }
        if (this.state == CODAState.ERROR) {
            return;
        }
        this.setState(CODAState.PAUSED);
    }

    private void download(Command cmd) {
        this.logger.info("Emu " + this.name + " download: change state to DOWNLOADING");
        this.setState(CODAState.DOWNLOADING);
        try {
            Node modulesConfig = Configurer.getNode(this.configuration(), "component/modules");
            if (modulesConfig == null) {
                throw new DataNotFoundException("config never loaded / faulty");
            }
            if (!modulesConfig.hasChildNodes()) {
                throw new DataNotFoundException("modules section present in config, but no modules");
            }
            if (this.codaClass != CODAClass.TS) {
                try {
                    for (DataTransport t : this.transports) {
                        if (this.debug) {
                            System.out.println("Emu " + this.name + " download: transport " + t.name() + " reset");
                        }
                        t.reset();
                    }
                    this.transports.clear();
                    Node m = Configurer.getNode(this.configuration(), "component/transports");
                    if (m == null || !m.hasChildNodes()) {
                        throw new DataNotFoundException("transport section or info missing in config");
                    }
                    NodeList l = m.getChildNodes();
                    for (int ix = 0; ix < l.getLength(); ++ix) {
                        Class<?> c;
                        String transportClass;
                        Node n = l.item(ix);
                        if (n.getNodeType() != 1) continue;
                        String transportType = n.getNodeName();
                        HashMap<String, String> attrib = new HashMap<String, String>(16);
                        if (n.hasAttributes()) {
                            NamedNodeMap attr = n.getAttributes();
                            for (int jx = 0; jx < attr.getLength(); ++jx) {
                                Node a = attr.item(jx);
                                attrib.put(a.getNodeName(), a.getNodeValue());
                            }
                        }
                        if (transportType.equalsIgnoreCase("server")) {
                            attrib.put("server", "true");
                        } else {
                            attrib.put("server", "false");
                        }
                        String transportName = (String)attrib.get("name");
                        if (transportName == null) {
                            throw new DataNotFoundException("transport name attribute missing in config");
                        }
                        if (this.debug) {
                            System.out.println("Emu " + this.name + " download: creating " + transportName);
                        }
                        if ((transportClass = (String)attrib.get("class")) == null) {
                            throw new DataNotFoundException("transport class attribute missing in config");
                        }
                        String implName = "org.jlab.coda.emu.support.transport.DataTransportImpl" + transportClass;
                        if (transportClass.equals("Fifo")) continue;
                        try {
                            c = Emu.class.getClassLoader().loadClass(implName);
                        }
                        catch (Exception e) {
                            throw new CmdExecException("cannot load transport class", e);
                        }
                        try {
                            Class[] parameterTypes = new Class[]{String.class, Map.class, Emu.class};
                            Constructor<?> co = c.getConstructor(parameterTypes);
                            Object[] args = new Object[]{transportName, attrib, this};
                            this.transports.add((DataTransport)co.newInstance(args));
                            continue;
                        }
                        catch (Exception e) {
                            throw new CmdExecException("cannot create transport object", e);
                        }
                    }
                }
                catch (DataNotFoundException e) {
                    this.logger.warn("Emu " + this.name + " download: transport section missing/incomplete from config");
                }
                for (DataTransport transport : this.transports) {
                    if (this.debug) {
                        System.out.println("Emu " + this.name + " download: pass download down to " + transport.name());
                    }
                    transport.download();
                }
            }
            this.modules.clear();
            Node n = modulesConfig.getFirstChild();
            do {
                EmuModule module;
                String moduleClassName;
                if (n.getNodeType() != 1) continue;
                NamedNodeMap nm2 = n.getAttributes();
                HashMap<String, String> attributeMap = new HashMap<String, String>(16);
                for (int j = 0; j < nm2.getLength(); ++j) {
                    Node a = nm2.item(j);
                    attributeMap.put(a.getNodeName(), a.getNodeValue());
                }
                Node typeAttr = nm2.getNamedItem("class");
                if (typeAttr == null) {
                    throw new DataNotFoundException("module " + n.getNodeName() + " has no class attribute");
                }
                switch (moduleClassName = typeAttr.getNodeValue()) {
                    case "EventRecording": {
                        module = new EventRecording(n.getNodeName(), attributeMap, this);
                        break;
                    }
                    case "EventBuilding": {
                        module = new FastEventBuilder(n.getNodeName(), attributeMap, this);
                        break;
                    }
                    case "RocSimulation": {
                        module = new RocSimulation(n.getNodeName(), attributeMap, this);
                        break;
                    }
                    case "FarmController": {
                        module = new FarmController(n.getNodeName(), attributeMap, this);
                        break;
                    }
                    case "TsSimulation": {
                        module = new TsSimulation(n.getNodeName(), attributeMap, this);
                        break;
                    }
                    default: {
                        if (this.debug) {
                            System.out.println("Emu " + this.name + " download: load module class " + moduleClassName + " to create a module of name " + n.getNodeName() + "\n  in classpath = " + System.getProperty("java.class.path"));
                        }
                        Class<?> c = Class.forName(moduleClassName);
                        Class[] parameterTypes = new Class[]{String.class, Map.class, Emu.class};
                        Constructor<?> co = c.getConstructor(parameterTypes);
                        Object[] args = new Object[]{n.getNodeName(), attributeMap, this};
                        module = (EmuModule)co.newInstance(args);
                    }
                }
                if (this.debug) {
                    System.out.println("Emu " + this.name + " download: create module " + module.name());
                }
                module.registerEndCallback(new EmuEventNotify());
                module.registerPrestartCallback(new EmuEventNotify());
                this.dataPath.associateModule(module);
                this.modules.add(module);
            } while ((n = n.getNextSibling()) != null);
            for (EmuModule module : this.modules) {
                if (this.debug) {
                    System.out.println("Emu " + this.name + " download: pass download to module " + module.name());
                }
                module.download();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("Emu " + this.name + " download: jvm out of memory, exiting");
            this.setErrorState("Emu " + this.name + " download: jvm out of memory, exiting");
            System.exit(-1);
        }
        catch (Exception e) {
            System.out.println("Emu " + this.name + " download error: " + e.getMessage());
            this.setErrorState("Emu " + this.name + " download: " + e.getMessage());
            return;
        }
        if (this.state == CODAState.ERROR) {
            return;
        }
        this.setState(CODAState.DOWNLOADED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(Command cmd) {
        boolean newConfigLoaded;
        Document oldConfig;
        block85: {
            this.logger.info("Emu " + this.name + " config: change state to CONFIGURING");
            this.setState(CODAState.CONFIGURING);
            oldConfig = this.loadedConfig;
            newConfigLoaded = false;
            this.outputDestinations = null;
            try {
                cMsgPayloadItem pItem;
                cMsgMessage msg = cmd.getMessage();
                String rcConfigString = null;
                String rcConfigFile = null;
                boolean isNewConfig = false;
                try {
                    pItem = cmd.getArg("configId");
                    if (pItem != null) {
                        this.runTypeId = pItem.getInt();
                    }
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
                if (msg != null) {
                    try {
                        String[] ipList;
                        pItem = cmd.getArg("ipList");
                        if (pItem != null) {
                            ipList = pItem.getStringArray();
                            System.out.println("CONFIG: Client IP List found:");
                            for (String s : ipList) {
                                System.out.println(" ip = " + s);
                            }
                        }
                        if ((pItem = cmd.getArg("baList")) != null) {
                            ipList = pItem.getStringArray();
                            System.out.println("CONFIG: Client Broadcast List found:");
                            for (String s : ipList) {
                                System.out.println(" ip = " + s);
                            }
                        }
                        if ((pItem = cmd.getArg("emuRocConfig")) != null) {
                            rcConfigString = pItem.getString();
                            isNewConfig = true;
                        } else {
                            pItem = cmd.getArg("fileContent");
                            if (pItem != null) {
                                rcConfigString = pItem.getString();
                                pItem = cmd.getArg("fileChanged");
                                if (pItem != null) {
                                    isNewConfig = pItem.getInt() == 1;
                                }
                            }
                        }
                        pItem = cmd.getArg("fileName");
                        if (pItem != null) {
                            rcConfigFile = pItem.getString();
                        }
                        if ((pItem = cmd.getArg("nStreams")) != null) {
                            this.dataStreamCount = pItem.getInt();
                            System.out.println("Emu " + this.name + " config: data stream count = " + this.dataStreamCount);
                        }
                        if ((pItem = cmd.getArg("streamID")) != null) {
                            this.dataStreamId = pItem.getInt();
                            System.out.println("Emu " + this.name + " config: data stream ID = " + this.dataStreamId);
                        }
                        if ((pItem = cmd.getArg("platformHost")) != null) {
                            this.platformIpAddresses = pItem.getStringArray();
                            pItem = cmd.getArg("platformPort");
                            if (pItem != null) {
                                this.platformTcpPort = pItem.getInt();
                            }
                            System.out.println("Emu " + this.name + " config: connect to cMsg server");
                            this.cmsgPortal.cMsgServerConnect();
                        }
                    }
                    catch (cMsgException ipList) {
                    }
                    catch (EmuException e) {
                        System.out.println("Emu " + this.name + " config: " + e.getMessage());
                        this.setErrorState("Emu " + this.name + " config: " + e.getMessage());
                        Configurer.setLogger(null);
                        return;
                    }
                }
                if (rcConfigString != null) {
                    if (this.configSource != ConfigSource.RC_STRING || isNewConfig) {
                        System.out.println("Emu " + this.name + " config: loading new string config = \n" + rcConfigString);
                        Configurer.setLogger(this.logger);
                        this.loadedConfig = Configurer.parseString(rcConfigString);
                        Configurer.removeEmptyTextNodes(this.loadedConfig.getDocumentElement());
                        newConfigLoaded = true;
                    } else if (this.debug) {
                        System.out.println("Emu " + this.name + " config: no change to string config");
                    }
                    this.configSource = ConfigSource.RC_STRING;
                    break block85;
                }
                if (rcConfigFile != null) {
                    File file = new File(rcConfigFile);
                    if (!file.exists() || !file.isFile()) {
                        throw new DataNotFoundException("File " + rcConfigFile + " cannot be found");
                    }
                    boolean loadFile = true;
                    long modTime = file.lastModified();
                    if ((this.configSource == ConfigSource.RC_FILE && !cmd.isFromDebugGui() || this.configSource == ConfigSource.GUI_FILE && cmd.isFromDebugGui()) && rcConfigFile.equals(this.msgConfigFile) && modTime == this.configFileModifiedTime) {
                        loadFile = false;
                    }
                    if (loadFile) {
                        System.out.println("Emu " + this.name + " config: loading file " + rcConfigFile);
                        Configurer.setLogger(this.logger);
                        this.loadedConfig = Configurer.parseFile(rcConfigFile);
                        Configurer.removeEmptyTextNodes(this.loadedConfig.getDocumentElement());
                        this.msgConfigFile = rcConfigFile;
                        this.configFileModifiedTime = modTime;
                        newConfigLoaded = true;
                    }
                    this.configSource = cmd.isFromDebugGui() ? ConfigSource.GUI_FILE : ConfigSource.RC_FILE;
                    break block85;
                }
                throw new DataNotFoundException("Emu config: No config file provided from RC or debug emu");
            }
            catch (DataNotFoundException e) {
                System.out.println("Emu " + this.name + " config: " + e.getMessage());
                this.setErrorState("Emu " + this.name + " config: " + e.getMessage());
                return;
            }
            finally {
                Configurer.setLogger(null);
            }
        }
        if (this.lastConfigHadError) {
            newConfigLoaded = true;
        }
        if (this.debugGUI != null) {
            if (oldConfig != null) {
                this.debugGUI.removeDocument(oldConfig);
            }
            this.debugGUI.addDocument(this.loadedConfig);
        }
        if (newConfigLoaded) {
            if (this.debug) {
                System.out.println("Emu " + this.name + " config: LOAD NEW config, type = " + (Object)((Object)this.codaClass));
            }
            try {
                Node componentConfig = Configurer.getNode(this.loadedConfig, "component");
                NamedNodeMap nm = componentConfig.getAttributes();
                Node attr = nm.getNamedItem("type");
                if (attr != null) {
                    CODAClass myClass = CODAClass.get(attr.getNodeValue());
                    if (this.debug) {
                        System.out.println("Emu " + this.name + " config: Got config type = " + (Object)((Object)myClass) + ", I was " + (Object)((Object)this.codaClass));
                    }
                    if (myClass != null) {
                        if (this.codaClass != null && this.codaClass != CODAClass.EMU && this.codaClass != myClass) {
                            this.setErrorState("Emu " + this.name + " config: conflicting CODA types: rc says " + (Object)((Object)myClass) + ", emu cmd line has " + (Object)((Object)this.codaClass));
                            this.lastConfigHadError = true;
                            return;
                        }
                        this.codaClass = myClass;
                    }
                }
                this.dataPath = null;
                int moduleCount = 0;
                int usedModules = 0;
                int inputFifoCount = 0;
                int inputChannelCount = 0;
                int outputFifoCount = 0;
                int outputChannelCount = 0;
                Node modulesConfig = Configurer.getNode(this.loadedConfig, "component/modules");
                if (!modulesConfig.hasChildNodes()) {
                    throw new DataNotFoundException("modules section present in config, but no modules");
                }
                int dataPathCount = 0;
                int firstModuleIndex = 0;
                this.firstModuleInputChannelCount = 0;
                boolean foundFirstModule = false;
                this.fileOutputCount = 0;
                HashSet<String> outFifoNames = new HashSet<String>(5);
                NodeList childList = modulesConfig.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node modIdNode;
                    Node moduleNode = childList.item(j);
                    if (moduleNode.getNodeType() != 1) continue;
                    ++moduleCount;
                    String moduleName = moduleNode.getNodeName();
                    int codaID = -1;
                    NamedNodeMap map = moduleNode.getAttributes();
                    if (map != null && (modIdNode = map.getNamedItem("id")) != null) {
                        try {
                            codaID = Integer.parseInt(modIdNode.getNodeValue());
                            if (codaID < 0) {
                                codaID = -1;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    NodeList childChannelList = moduleNode.getChildNodes();
                    if (!foundFirstModule) {
                        firstModuleIndex = j;
                        foundFirstModule = true;
                    }
                    inputChannelCount = 0;
                    inputFifoCount = 0;
                    outputChannelCount = 0;
                    outputFifoCount = 0;
                    String channelTransName = null;
                    String channelName = null;
                    String inputFifoName = null;
                    String outputFifoName = null;
                    long splitSize = 0L;
                    boolean foundSplitSize = false;
                    for (int i = 0; i < childChannelList.getLength(); ++i) {
                        Node channelNameNode;
                        NamedNodeMap nnm;
                        Node channelNode = childChannelList.item(i);
                        if (channelNode.getNodeType() != 1 || (nnm = channelNode.getAttributes()) == null || (channelNameNode = nnm.getNamedItem("name")) == null) continue;
                        channelName = channelNameNode.getNodeValue();
                        Node channelTranspNode = nnm.getNamedItem("transp");
                        if (channelTranspNode == null) continue;
                        channelTransName = channelTranspNode.getNodeValue();
                        if (channelNode.getNodeName().equalsIgnoreCase("inchannel")) {
                            ++inputChannelCount;
                            if (channelTransName.equals("Fifo")) {
                                if (!outFifoNames.contains(channelName)) {
                                    System.out.println("Emu " + this.name + " config: put modules in correct order, define out fifo before in");
                                    this.setErrorState("Emu " + this.name + " config: put modules in correct order, define out fifo before in");
                                    return;
                                }
                                ++inputFifoCount;
                                inputFifoName = channelName;
                                continue;
                            }
                            if (j != firstModuleIndex) continue;
                            ++this.firstModuleInputChannelCount;
                            continue;
                        }
                        if (!channelNode.getNodeName().equalsIgnoreCase("outchannel")) continue;
                        Node filenameNode = nnm.getNamedItem("fileName");
                        if (filenameNode != null) {
                            ++this.fileOutputCount;
                            if (!foundSplitSize) {
                                String splitStr;
                                Node splitNode = nnm.getNamedItem("split");
                                if (splitNode != null && (splitStr = splitNode.getNodeValue()) != null) {
                                    try {
                                        splitSize = Long.parseLong(splitStr);
                                        foundSplitSize = true;
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                            } else {
                                long newSplitSize = 0L;
                                Node splitNode = nnm.getNamedItem("split");
                                if (splitNode != null) {
                                    String splitStr = splitNode.getNodeValue();
                                    if (splitStr != null) {
                                        try {
                                            newSplitSize = Long.parseLong(splitStr);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    if (newSplitSize != 0L && newSplitSize != splitSize) {
                                        splitNode.setNodeValue("" + splitSize);
                                        this.sendRcWarningMessage("setting split from " + newSplitSize + " to " + splitSize + " for file channel " + channelNameNode.getNodeValue());
                                        System.out.println("Emu " + this.name + " config: setting split from " + newSplitSize + " to " + splitSize + " for file channel " + channelNameNode.getNodeValue());
                                    }
                                }
                            }
                        }
                        ++outputChannelCount;
                        if (channelTransName.equals("Fifo")) {
                            ++outputFifoCount;
                            outputFifoName = channelName;
                            outFifoNames.add(channelName);
                        }
                        int chanID = -1;
                        Node channelIdNode = nnm.getNamedItem("id");
                        if (channelIdNode != null) {
                            try {
                                chanID = Integer.parseInt(channelIdNode.getNodeValue());
                                if (chanID < 0) {
                                    chanID = -1;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (codaID <= -1 || chanID <= -1 || codaID == chanID) continue;
                        throw new DataNotFoundException("CODA id (" + codaID + ") does not match config file output chan id (" + chanID + ")");
                    }
                    if (inputFifoCount > 1 || inputFifoCount == 1 && inputChannelCount > 2 || outputFifoCount > 1 || outputFifoCount == 1 && outputChannelCount > 1) {
                        throw new DataNotFoundException("only 1 input/output channel allowed with fifo in/out");
                    }
                    if (inputFifoCount == 1 && outputFifoCount == 1 && inputFifoName.equals(outputFifoName)) {
                        throw new DataNotFoundException("input & output fifos for " + moduleName + " must be different");
                    }
                    if (inputFifoCount < 1) {
                        ++dataPathCount;
                        this.dataPath = new EmuDataPath(moduleName, null, outputFifoName);
                        ++usedModules;
                    }
                    if (dataPathCount <= 1) continue;
                    throw new DataNotFoundException("only 1 data path allowed");
                }
                if (dataPathCount < 1 && inputFifoCount > 0) {
                    throw new DataNotFoundException("fifo not allowed to start data path");
                }
                if (this.dataPath == null) {
                    throw new DataNotFoundException("no data path found");
                }
                block26: while (true) {
                    boolean isFirstModule = false;
                    for (int j = 0; j < childList.getLength(); ++j) {
                        String moduleName;
                        Node moduleNode = childList.item(j);
                        if (moduleNode.getNodeType() != 1 || this.dataPath.containsModuleName(moduleName = moduleNode.getNodeName())) continue;
                        String channelTransName = null;
                        String channelName = null;
                        String inputFifoName = null;
                        String outputFifoName = null;
                        NodeList childChannelList = moduleNode.getChildNodes();
                        for (int i = 0; i < childChannelList.getLength(); ++i) {
                            Node channelNameNode;
                            NamedNodeMap nnm;
                            Node channelNode = childChannelList.item(i);
                            if (channelNode.getNodeType() != 1 || (nnm = channelNode.getAttributes()) == null || (channelNameNode = nnm.getNamedItem("name")) == null) continue;
                            channelName = channelNameNode.getNodeValue();
                            Node channelTranspNode = nnm.getNamedItem("transp");
                            if (channelTranspNode == null) continue;
                            channelTransName = channelTranspNode.getNodeValue();
                            if (channelNode.getNodeName().equalsIgnoreCase("inchannel")) {
                                if (!channelTransName.equals("Fifo")) continue;
                                inputFifoName = channelName;
                                continue;
                            }
                            if (!channelNode.getNodeName().equalsIgnoreCase("outchannel") || !channelTransName.equals("Fifo")) continue;
                            outputFifoName = channelName;
                        }
                        if (!this.dataPath.addModuleName(moduleName, inputFifoName, outputFifoName)) continue;
                        ++usedModules;
                        continue block26;
                    }
                    break;
                }
                if (moduleCount != usedModules) {
                    throw new DataNotFoundException("not all modules in data path");
                }
                if (this.dataPath.getModules().getLast().hasOutputFifo) {
                    throw new DataNotFoundException("last module cannot have output fifo");
                }
            }
            catch (OutOfMemoryError e) {
                System.out.println("Emu " + this.name + " config: jvm out of memory, exiting");
                this.setErrorState("Emu " + this.name + " config: jvm out of memory, exiting");
                System.exit(-1);
            }
            catch (DataNotFoundException e) {
                System.out.println("Emu " + this.name + " config: " + e.getMessage());
                this.setErrorState("Emu " + this.name + " config: " + e.getMessage());
                this.lastConfigHadError = true;
                return;
            }
            this.lastConfigHadError = false;
        }
        if (this.state == CODAState.ERROR) {
            return;
        }
        this.setState(CODAState.CONFIGURED);
    }

    static /* synthetic */ boolean access$1000(Emu x0) {
        return x0.statusReportingOn;
    }

    static /* synthetic */ CMSGPortal access$1100(Emu x0) {
        return x0.cmsgPortal;
    }

    static /* synthetic */ CODAClass access$1200(Emu x0) {
        return x0.codaClass;
    }

    static /* synthetic */ String[] access$1300(Emu x0) {
        return x0.outputDestinations;
    }

    class StatusReportingThread
    extends Thread {
        private final cMsgMessage reportMsg = new cMsgMessage();
        private volatile long time;

        public long getTime() {
            return this.time;
        }

        StatusReportingThread() {
            this.reportMsg.setSubject(Emu.this.name);
            this.reportMsg.setType("rc/report/status");
            this.reportMsg.setReliableSend(false);
            this.setDaemon(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            long lastMsgTime = 0L;
            this.time = System.currentTimeMillis();
            try {
                while (!Thread.interrupted()) {
                    if (this.time - lastMsgTime >= (long)Emu.this.statusReportingPeriod) {
                        this.sendStatusMessage();
                        lastMsgTime = this.time;
                    }
                    try {
                        Thread.sleep(250L);
                        this.time = System.currentTimeMillis();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * Unable to fully structure code
         */
        synchronized void sendStatusMessage() {
            block16: {
                if (!Emu.access$1000(Emu.this) || Emu.access$1100(Emu.this).getRcServer() == null || !Emu.access$1100(Emu.this).getRcServer().isConnected()) break block16;
                eventCount = 0L;
                wordCount = 0L;
                eventRate = 0.0f;
                dataRate = 0.0f;
                maxEvSize = 0;
                minEvSize = 0;
                avgEvSize = 0;
                chunk_X_EtBuf = 0;
                timeToBuild = null;
                inChanLevels = null;
                outChanLevels = null;
                inChanNames = null;
                outChanNames = null;
                statsModule = Emu.this.getStatisticsModule();
                if (statsModule != null) {
                    stats = statsModule.getStatistics();
                    if (stats != null) {
                        eventCount = (Long)stats[0];
                        wordCount = (Long)stats[1];
                        eventRate = ((Float)stats[2]).floatValue();
                        dataRate = ((Float)stats[3]).floatValue();
                        maxEvSize = (Integer)stats[4];
                        minEvSize = (Integer)stats[5];
                        avgEvSize = (Integer)stats[6];
                        chunk_X_EtBuf = (Integer)stats[7];
                        timeToBuild = (int[])stats[8];
                    }
                    if (Emu.access$500(Emu.this) == CODAState.ACTIVE) {
                        inChanLevels = statsModule.getInputLevels();
                        outChanLevels = statsModule.getOutputLevels();
                        inChanNames = statsModule.getInputNames();
                        outChanNames = statsModule.getOutputNames();
                    } else {
                        inChanLevels = null;
                        outChanLevels = null;
                        inChanNames = null;
                        outChanNames = null;
                    }
                }
                try {
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("state", Emu.this.state().name().toLowerCase()));
                    v0 = Emu.access$1200(Emu.this);
                    Emu.access$1200(Emu.this);
                    if (v0 == CODAClass.PEBER) ** GOTO lbl-1000
                    v1 = Emu.access$1200(Emu.this);
                    Emu.access$1200(Emu.this);
                    if (v1 == CODAClass.SEBER) lbl-1000:
                    // 2 sources

                    {
                        Emu.access$1200(Emu.this);
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("codaClass", CODAClass.EBER.name()));
                    } else {
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("codaClass", Emu.access$1200(Emu.this).name()));
                    }
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("objectType", "coda3"));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("eventCount", (int)eventCount));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("eventCount64", eventCount));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("dataCount", wordCount));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("eventRate", eventRate));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("dataRate", (double)dataRate));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("maxEventSize", maxEvSize));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("minEventSize", minEvSize));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("avgEventSize", avgEvSize));
                    this.reportMsg.addPayloadItem(new cMsgPayloadItem("chunk_X_EtBuf", chunk_X_EtBuf));
                    if (inChanLevels != null && inChanLevels.length > 0) {
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("inputChanLevels", inChanLevels));
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("inputChanNames", inChanNames));
                    } else {
                        this.reportMsg.removePayloadItem("inputChanLevels");
                        this.reportMsg.removePayloadItem("inputChanNames");
                    }
                    if (outChanLevels != null && outChanLevels.length > 0) {
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("outputChanLevels", outChanLevels));
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("outputChanNames", outChanNames));
                    } else {
                        this.reportMsg.removePayloadItem("outputChanLevels");
                        this.reportMsg.removePayloadItem("outputChanNames");
                    }
                    if (timeToBuild != null && timeToBuild.length > 0) {
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("timeToBuild", timeToBuild));
                    } else {
                        this.reportMsg.removePayloadItem("timeToBuild");
                    }
                    if (Emu.access$1300(Emu.this) != null) {
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("fileName", Emu.access$1300(Emu.this)[0]));
                        this.reportMsg.addPayloadItem(new cMsgPayloadItem("destinationNames", Emu.access$1300(Emu.this)));
                    } else {
                        this.reportMsg.removePayloadItem("fileName");
                        this.reportMsg.removePayloadItem("destinationNames");
                    }
                    Emu.access$1100(Emu.this).getRcServer().send(this.reportMsg);
                }
                catch (cMsgException e) {
                    Emu.access$200(Emu.this).warn(e.getMessage());
                }
            }
        }
    }

    private class TransitionExecutor
    implements Runnable {
        volatile boolean endThread;
        volatile boolean deadThread;

        private TransitionExecutor() {
        }

        public void stop() {
            this.endThread = true;
            Emu.this.transitionThread.interrupt();
            try {
                Emu.this.transitionThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Emu.this.transitionThread.isAlive()) {
                Emu.this.logger.info("Emu " + Emu.this.name + ": WARNING transition thread still alive even after interrupt");
            }
        }

        public void kill() {
            this.endThread = true;
        }

        public void killAndwaitTillDead() {
            this.endThread = true;
            try {
                while (!this.deadThread) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            CODAStateIF oldState = null;
            try {
                while (true) {
                    if (Emu.this.resetting) {
                        Thread.sleep(200L);
                        continue;
                    }
                    Command cmd = (Command)Emu.this.mailbox.poll(500L, TimeUnit.MILLISECONDS);
                    if (this.endThread) {
                        this.deadThread = true;
                        return;
                    }
                    if (cmd != null) {
                        try {
                            Emu.this.execute(cmd);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                            Emu.this.logger.warn("Emu " + Emu.this.name + ": command, " + cmd + ", not supported ");
                            continue;
                        }
                    }
                    if (Emu.this.state == null || Emu.this.state == oldState) continue;
                    if (Emu.this.debugGUI != null) {
                        Emu.this.debugGUI.getToolBar().updateButtons(Emu.this.state);
                    }
                    try {
                        Configurer.setValue(Emu.this.localConfig, "status/state", Emu.this.state.toString());
                    }
                    catch (DataNotFoundException e) {
                        Emu.this.logger.info("Emu " + Emu.this.name + ": failed to set state in local config");
                    }
                    oldState = Emu.this.state;
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Emu.this.logger.info("Emu " + Emu.this.name + ": interrupted transition thread");
                return;
            }
            finally {
                Emu.this.logger.info("Emu " + Emu.this.name + ": exit transition thread");
                this.deadThread = true;
            }
        }
    }

    private static enum ConfigSource {
        RC_STRING,
        RC_FILE,
        GUI_FILE;

    }
}

